/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.core.resources.IResource;

public class NamingConventionFunctionChecker
extends AbstractIndexAstChecker {
    private static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.NamingConventionFunctionChecker";
    public static final String PARAM_KEY = "pattern";
    public static final String PARAM_METHODS = "macro";
    public static final String PARAM_EXCEPT_ARG_LIST = "exceptions";

    public void processAst(IASTTranslationUnit ast) {
        final List pts = this.getProblemsByMainId(ER_ID, (IResource)this.getFile());
        try {
            ast.accept(new ASTVisitor(){
                {
                    this.shouldVisitDeclarations = true;
                }

                public int visit(IASTDeclaration element) {
                    IASTName astName;
                    String name;
                    if (element instanceof IASTFunctionDefinition && (name = this.getSearchableName(astName = ((IASTFunctionDefinition)element).getDeclarator().getName())) != null) {
                        for (IProblem pt : pts) {
                            if (!this.shouldReport(astName, pt)) {
                                return 1;
                            }
                            String parameter = (String)NamingConventionFunctionChecker.this.getPreference(pt, NamingConventionFunctionChecker.PARAM_KEY);
                            Pattern pattern = Pattern.compile(parameter);
                            if (pattern.matcher(name).find() || NamingConventionFunctionChecker.this.isFilteredArg(name, pt)) continue;
                            NamingConventionFunctionChecker.this.reportProblem(pt, (IASTNode)astName, new Object[]{name, parameter});
                        }
                    }
                    return 1;
                }

                private boolean shouldReport(IASTName astName, IProblem pt) {
                    if (astName instanceof ICPPASTQualifiedName) {
                        return NamingConventionFunctionChecker.this.shouldReportCppMethods(pt);
                    }
                    return true;
                }

                private String getSearchableName(IASTName astName) {
                    String name = astName.toString();
                    if (astName instanceof ICPPASTQualifiedName) {
                        ICPPASTQualifiedName cppAstName = (ICPPASTQualifiedName)astName;
                        if (cppAstName.isConversionOrOperator()) {
                            return null;
                        }
                        name = cppAstName.getLastName().toString();
                        if (name.startsWith("~")) {
                            return null;
                        }
                        ICPPASTNameSpecifier[] qualifier = cppAstName.getQualifier();
                        if (qualifier.length > 0 && cppAstName.getLastName().toString().equals(qualifier[qualifier.length - 1].toString())) {
                            return null;
                        }
                    }
                    return name;
                }
            });
        }
        catch (Exception e) {
            CodanCheckersActivator.log(e);
        }
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_KEY, CheckersMessages.NamingConventionFunctionChecker_LabelNamePattern, "^[a-z]");
        this.addPreference(problem, PARAM_METHODS, CheckersMessages.NamingConventionFunctionChecker_ParameterMethods, Boolean.TRUE);
        this.addListPreference(problem, PARAM_EXCEPT_ARG_LIST, CheckersMessages.GenericParameter_ParameterExceptions, CheckersMessages.GenericParameter_ParameterExceptionsItem);
    }

    public boolean shouldReportCppMethods(IProblem pt) {
        return (Boolean)this.getPreference(pt, PARAM_METHODS);
    }

    public boolean isFilteredArg(String arg, IProblem pt) {
        return this.isFilteredArg(arg, pt, PARAM_EXCEPT_ARG_LIST);
    }

    public boolean runInEditor() {
        return true;
    }
}

