/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.connectors;

import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.PropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.ui.property.connectors.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class SequenceFlowDetailComposite
extends AbstractDetailComposite {
    private Button addRemoveConditionButton;
    private Button setDefaultFlowCheckbox;

    public SequenceFlowDetailComposite(Composite parent, int style) {
        super(parent, style);
    }

    public SequenceFlowDetailComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public AbstractPropertiesProvider getPropertiesProvider(EObject object) {
        if (this.propertiesProvider == null) {
            this.propertiesProvider = new AbstractPropertiesProvider(object){
                String[] properties;
                {
                    this.properties = new String[]{"language", "body", "evaluatesToTypeRef"};
                }

                public String[] getProperties() {
                    return this.properties;
                }
            };
        }
        return this.propertiesProvider;
    }

    public void createBindings(final EObject be) {
        this.bindAttribute(be, "name");
        if (this.isModelObjectEnabled("SequenceFlow", "conditionExpression")) {
            final SequenceFlow sequenceFlow = (SequenceFlow)be;
            TargetRuntime rt = TargetRuntime.getRuntime((EObject)be);
            this.addRemoveConditionButton = this.getToolkit().createButton((Composite)this, "", 8);
            this.addRemoveConditionButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
            this.addRemoveConditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TransactionalEditingDomain domain = SequenceFlowDetailComposite.this.getDiagramEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            if (sequenceFlow.getConditionExpression() != null) {
                                sequenceFlow.setConditionExpression(null);
                            } else {
                                Expression exp = (Expression)SequenceFlowDetailComposite.this.createModelObject(FormalExpression.class);
                                sequenceFlow.setConditionExpression(exp);
                                SequenceFlowDetailComposite.this.setDefault(sequenceFlow, null);
                            }
                            SequenceFlowDetailComposite.this.setBusinessObject(be);
                        }
                    });
                }
            });
            Expression exp = sequenceFlow.getConditionExpression();
            if (exp != null) {
                this.addRemoveConditionButton.setText(Messages.SequenceFlowDetailComposite_Remove_Button);
                AbstractDetailComposite composite = PropertiesCompositeFactory.INSTANCE.createDetailComposite(Expression.class, (Composite)this, rt, 2048);
                composite.setBusinessObject((EObject)exp);
                Point size = composite.computeSize(-1, -1);
                GridData gd = (GridData)composite.getLayoutData();
                gd.widthHint = size.x;
                gd.heightHint = size.y;
                composite.setBusinessObject((EObject)exp);
                composite.setTitle(Messages.SequenceFlowDetailComposite_Condition_Expression_Title);
            } else {
                this.addRemoveConditionButton.setText(Messages.SequenceFlowDetailComposite_Add_Button);
                if (sequenceFlow.getSourceRef() instanceof FlowNode) {
                    FlowNode flowNode = sequenceFlow.getSourceRef();
                    String objectName = flowNode.getName();
                    if (objectName != null && objectName.isEmpty()) {
                        objectName = null;
                    }
                    String typeName = ExtendedPropertiesProvider.getLabel((EObject)flowNode);
                    if (this.allowDefault(sequenceFlow)) {
                        this.setDefaultFlowCheckbox = this.getToolkit().createButton((Composite)this, "", 32);
                        GridData data = new GridData(16384, 0x1000000, true, false, 3, 1);
                        if (!this.allowDefault(sequenceFlow)) {
                            data.exclude = true;
                            this.setDefaultFlowCheckbox.setVisible(false);
                        }
                        this.setDefaultFlowCheckbox.setLayoutData((Object)data);
                        this.setDefaultFlowCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                TransactionalEditingDomain domain = SequenceFlowDetailComposite.this.getDiagramEditor().getEditingDomain();
                                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                                    protected void doExecute() {
                                        if (SequenceFlowDetailComposite.this.getDefault(sequenceFlow) != sequenceFlow) {
                                            SequenceFlowDetailComposite.this.setDefault(sequenceFlow, (EObject)sequenceFlow);
                                        } else {
                                            SequenceFlowDetailComposite.this.setDefault(sequenceFlow, null);
                                        }
                                    }
                                });
                            }
                        });
                        this.setDefaultFlowCheckbox.setSelection(this.getDefault(sequenceFlow) == sequenceFlow);
                        this.setDefaultFlowCheckbox.setText(NLS.bind((String)Messages.SequenceFlowDetailComposite_Default_Flow_Label, (Object)typeName, (Object)(objectName == null ? "" : " \"" + objectName + "\"")));
                    }
                }
            }
        }
    }

    private boolean allowDefault(SequenceFlow sf) {
        EStructuralFeature feature;
        FlowNode obj = sf.getSourceRef();
        return obj == null || (feature = obj.eClass().getEStructuralFeature("default")) != null && this.isModelObjectEnabled(obj.eClass(), feature);
    }

    private void setDefault(SequenceFlow sf, EObject target) {
        EStructuralFeature feature;
        FlowNode obj = sf.getSourceRef();
        if (obj != null && (feature = obj.eClass().getEStructuralFeature("default")) != null && obj.eGet(feature) != target) {
            obj.eSet(feature, (Object)target);
        }
    }

    private EObject getDefault(SequenceFlow sf) {
        EStructuralFeature feature;
        FlowNode obj = sf.getSourceRef();
        if (obj != null && (feature = obj.eClass().getEStructuralFeature("default")) != null) {
            return (EObject)obj.eGet(feature);
        }
        return null;
    }
}

