/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AbstractPushPullFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.CollapseFlowNodeFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.osgi.util.NLS;

public class PushdownFeature
extends AbstractPushPullFeature {
    public PushdownFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.PushdownFeature_Name;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Messages.PushdownFeature_Description;
        }
        return this.description;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_PUSHDOWN;
    }

    public boolean isAvailable(IContext context) {
        PictogramElement pe;
        PictogramElement[] pes;
        return context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()) != null && pes.length == 1 && !ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)(pe = pes[0]));
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)pe)) {
                return false;
            }
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            this.description = NLS.bind((String)Messages.PushdownFeature_Description_1, (Object)ModelUtil.getLabel((Object)bo));
            if (bo instanceof Participant) {
                if (FeatureSupport.isParticipantReference((Diagram)this.getDiagram(), (Participant)((Participant)bo))) {
                    return false;
                }
                bo = ((Participant)bo).getProcessRef();
            }
            if (bo instanceof FlowElementsContainer) {
                return DIUtils.findBPMNDiagram((BaseElement)((BaseElement)bo)) == null;
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        this.containerShape = (ContainerShape)context.getPictogramElements()[0];
        this.oldBpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)this.containerShape);
        this.bpmnShape = null;
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)this.containerShape);
        if (bo instanceof Participant) {
            this.bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)this.oldBpmnDiagram, (BaseElement)((Participant)bo));
            this.businessObject = ((Participant)bo).getProcessRef();
        } else if (bo instanceof FlowElementsContainer) {
            this.businessObject = (FlowElementsContainer)bo;
            this.bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)this.oldBpmnDiagram, (BaseElement)this.businessObject);
        }
        this.oldDiagram = DIUtils.findDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)this.oldBpmnDiagram);
        this.newBpmnDiagram = DIUtils.createBPMNDiagram((BaseElement)this.businessObject);
        this.newDiagram = DIUtils.getOrCreateDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)this.newBpmnDiagram);
        this.collectDiagramElements(this.businessObject, this.oldBpmnDiagram);
        this.collectShapes(this.containerShape);
        this.collectConnections(this.containerShape);
        this.boundingRectangle = this.calculateBoundingRectangle(this.containerShape, this.childShapes);
        this.moveShapes((ContainerShape)this.oldDiagram, (ContainerShape)this.newDiagram, this.boundingRectangle.x, this.boundingRectangle.y);
        this.boundingRectangle = GraphicsUtil.getBoundingRectangle((List)this.childShapes);
        this.moveConnections(this.containerShape, (ContainerShape)this.newDiagram);
        this.moveDiagramElements(this.oldBpmnDiagram, this.newBpmnDiagram);
        this.moveGraphitiData(this.oldDiagram, this.newDiagram);
        if (FeatureSupport.isExpandableElement((BaseElement)this.businessObject)) {
            this.bpmnShape.setIsExpanded(true);
            CollapseFlowNodeFeature collapseFeature = new CollapseFlowNodeFeature(this.getFeatureProvider());
            collapseFeature.execute(context);
        }
        this.getFeatureProvider().getDiagramTypeProvider().resourceReloaded(this.newDiagram);
        FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), (List)this.internalConnections, (boolean)true);
    }

    @Override
    protected void collectDiagramElements(FlowElementsContainer businessObject, BPMNDiagram source) {
        for (LaneSet ls : businessObject.getLaneSets()) {
            for (Lane l : ls.getLanes()) {
                DiagramElement de = DIUtils.findDiagramElement((BPMNDiagram)source, (EObject)l);
                if (de == null) continue;
                this.diagramElements.add(de);
            }
        }
        for (FlowElement fe : businessObject.getFlowElements()) {
            DiagramElement de = DIUtils.findDiagramElement((BPMNDiagram)source, (EObject)fe);
            if (de != null) {
                this.diagramElements.add(de);
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.collectDiagramElements((FlowElementsContainer)fe, source);
        }
    }

    @Override
    protected void collectShapes(ContainerShape source) {
        for (Shape s : source.getChildren()) {
            if (!(s instanceof ContainerShape)) continue;
            this.childShapes.add(s);
            Shape l = FeatureSupport.getLabelShape((PictogramElement)s);
            if (l == null) continue;
            this.childShapes.add(l);
        }
    }

    @Override
    protected void moveGraphitiData(Diagram source, Diagram target) {
        for (Shape s : this.childShapes) {
            if (s.getLink() == null) continue;
            source.getPictogramLinks().remove((Object)s.getLink());
            target.getPictogramLinks().add((Object)s.getLink());
        }
        for (Connection c : this.internalConnections) {
            if (c.getLink() == null) continue;
            source.getPictogramLinks().remove((Object)c.getLink());
            target.getPictogramLinks().add((Object)c.getLink());
        }
    }

    @Override
    protected Point getChildOffset(ContainerShape targetContainerShape) {
        return GraphicsUtil.createPoint((int)50, (int)50);
    }

    @Override
    protected Rectangle calculateBoundingRectangle(ContainerShape containerShape, List<Shape> childShapes) {
        Point offset = this.getChildOffset(containerShape);
        Rectangle rect = GraphicsUtil.getBoundingRectangle(childShapes);
        rect.x -= offset.getX();
        rect.y -= offset.getY();
        return rect;
    }
}

