/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.task.DirectEditTaskFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.features.activity.AbstractActivityFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.CollapseFlowNodeFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.DeleteExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.ExpandFlowNodeFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.LayoutExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.PullupFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.PushdownFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.ResizeExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.UpdateExpandableActivityFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public abstract class AbstractExpandableActivityFeatureContainer
extends AbstractActivityFeatureContainer {
    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return new DirectEditTaskFeature(fp);
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = (MultiUpdateFeature)super.getUpdateFeature(fp);
        for (IUpdateFeature feature : multiUpdate.getFeatures()) {
            if (!(feature instanceof UpdateLabelFeature)) continue;
            multiUpdate.getFeatures().remove(feature);
            break;
        }
        multiUpdate.addFeature((IUpdateFeature)new UpdateExpandableActivityFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateLabelFeature(fp){

            protected ShapeStyle.LabelPosition getHorizontalLabelPosition(AbstractText text) {
                PictogramElement pe = FeatureSupport.getLabelOwner((GraphicsAlgorithm)text);
                BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)pe);
                if (FeatureSupport.isElementExpanded((BaseElement)be)) {
                    return ShapeStyle.LabelPosition.LEFT;
                }
                return ShapeStyle.LabelPosition.CENTER;
            }

            protected ShapeStyle.LabelPosition getVerticalLabelPosition(AbstractText text) {
                PictogramElement pe = FeatureSupport.getLabelOwner((GraphicsAlgorithm)text);
                BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)pe);
                if (FeatureSupport.isElementExpanded((BaseElement)be)) {
                    return ShapeStyle.LabelPosition.TOP;
                }
                return ShapeStyle.LabelPosition.CENTER;
            }
        });
        return multiUpdate;
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new LayoutExpandableActivityFeature(fp);
    }

    @Override
    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new ResizeExpandableActivityFeature(fp);
    }

    @Override
    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DeleteExpandableActivityFeature(fp);
    }

    @Override
    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        ICustomFeature[] superFeatures = super.getCustomFeatures(fp);
        ICustomFeature[] thisFeatures = new ICustomFeature[4 + superFeatures.length];
        thisFeatures[0] = new ExpandFlowNodeFeature(fp);
        thisFeatures[1] = new CollapseFlowNodeFeature(fp);
        thisFeatures[2] = new PushdownFeature(fp);
        thisFeatures[3] = new PullupFeature(fp);
        int i = 0;
        while (i < superFeatures.length) {
            thisFeatures[4 + i] = superFeatures[i];
            ++i;
        }
        return thisFeatures;
    }
}

