/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.wsdl.parsers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.common.wsdl.parsers.XmlSchemaParser;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;

public class WsdlParser {
    public static Definition loadWsdlDefinition(URI emfUri, ResourceSet resourceSet) {
        Resource resource = resourceSet.getResource(emfUri, true);
        return (Definition)resource.getContents().iterator().next();
    }

    public static Collection<Definition> loadAllWsdlDefinitions(URI emfUri, ResourceSet resourceSet) {
        Resource resource = resourceSet.getResource(emfUri, true);
        Definition def = (Definition)resource.getContents().iterator().next();
        return WsdlParser.findAllWsdlDefinitions(def);
    }

    public static Collection<Definition> findAllWsdlDefinitions(Definition alreadyLoadedDefinition) {
        HashSet<Definition> definitions = new HashSet<Definition>();
        definitions.add(alreadyLoadedDefinition);
        WsdlParser.processImports(alreadyLoadedDefinition.getImports(), definitions);
        return definitions;
    }

    public static boolean seemsValidDefinition(Definition def) {
        return def.getBindings().size() != 0 || def.getPortTypes().size() != 0 || def.getServices().size() != 0 || def.getImports().size() != 0 || def.getTypes() != null;
    }

    public static ResourceSet createBasicResourceSetForWsdl() {
        ResourceSet resourceSet = XmlSchemaParser.createBasicResourceSetForXmlSchema();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/wsdl/2003/WSDL", (Object)WSDLPackage.eINSTANCE);
        return resourceSet;
    }

    private static void processImports(Map<?, ?> imports, Collection<Definition> definitions) {
        for (Object o : imports.values()) {
            Definition d;
            if (o instanceof List) {
                for (Object oo : (List)o) {
                    Definition d2 = ((Import)oo).getEDefinition();
                    if (d2 == null || definitions.contains(d2)) continue;
                    definitions.add(d2);
                    WsdlParser.processImports(d2.getImports(), definitions);
                }
                continue;
            }
            if (!(o instanceof Definition) || definitions.contains(d = (Definition)o)) continue;
            definitions.add(d);
            WsdlParser.processImports(d.getImports(), definitions);
        }
    }
}

