/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.ide.authoring;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class WorkspaceUtils {
    private WorkspaceUtils() {
    }

    public static File getWorkspaceFile(String path) throws IOException {
        File soughtFile;
        String platformResourcePrefix = "platform:/resource/";
        String platformPluginPrefix = "platform:/plugin/";
        if (path.startsWith("platform:/resource/")) {
            Path relativePath = new Path(path.substring("platform:/resource/".length()));
            IFile soughtIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)relativePath);
            soughtFile = soughtIFile.getLocation().toFile();
        } else if (path.startsWith("platform:/plugin/")) {
            int bundleNameEnd = path.indexOf(47, "platform:/plugin/".length() + 1);
            String bundleName = path.substring("platform:/plugin/".length(), bundleNameEnd);
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle != null) {
                URL bundleFileURL = bundle.getEntry(path.substring(bundleNameEnd));
                URL fileURL = FileLocator.toFileURL((URL)bundleFileURL);
                soughtFile = new File(fileURL.getFile());
            } else {
                soughtFile = null;
            }
        } else {
            Path fullPath;
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            if (workspaceLocation.isPrefixOf((IPath)(fullPath = new Path(path)))) {
                fullPath = fullPath.removeFirstSegments(workspaceLocation.segmentCount());
            }
            IFile soughtIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)fullPath);
            soughtFile = soughtIFile.getLocation().toFile();
        }
        return soughtFile;
    }
}

