/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FutureObjects;
import org.apache.lucene.util.NumericUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LongRange
extends Field {
    public static final int BYTES = 8;

    public LongRange(String name, long[] min, long[] max) {
        super(name, LongRange.getType(min.length));
        this.setRangeValues(min, max);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("LongRange does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 8);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(long[] min, long[] max) {
        byte[] bytes;
        LongRange.checkArgs(min, max);
        if (min.length * 2 != this.type.pointDataDimensionCount() || max.length * 2 != this.type.pointDataDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDataDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[16 * min.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        LongRange.verifyAndEncode(min, max, bytes);
    }

    private static void checkArgs(long[] min, long[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min.length > 4) {
            throw new IllegalArgumentException("LongRange does not support greater than 4 dimensions");
        }
    }

    static byte[] encode(long[] min, long[] max) {
        LongRange.checkArgs(min, max);
        byte[] b = new byte[16 * min.length];
        LongRange.verifyAndEncode(min, max, b);
        return b;
    }

    static void verifyAndEncode(long[] min, long[] max, byte[] bytes) {
        int d = 0;
        int i = 0;
        int j = min.length * 8;
        while (d < min.length) {
            if (Double.isNaN(min[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in LongRange");
            }
            if (Double.isNaN(max[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in LongRange");
            }
            if (min[d] > max[d]) {
                throw new IllegalArgumentException("min value (" + min[d] + ") is greater than max value (" + max[d] + ")");
            }
            LongRange.encode(min[d], bytes, i);
            LongRange.encode(max[d], bytes, j);
            ++d;
            i += 8;
            j += 8;
        }
    }

    private static void encode(long val, byte[] bytes, int offset) {
        NumericUtils.longToSortableBytes(val, bytes, offset);
    }

    public long getMin(int dimension) {
        FutureObjects.checkIndex(dimension, this.type.pointDataDimensionCount() / 2);
        return LongRange.decodeMin(((BytesRef)this.fieldsData).bytes, dimension);
    }

    public long getMax(int dimension) {
        FutureObjects.checkIndex(dimension, this.type.pointDataDimensionCount() / 2);
        return LongRange.decodeMax(((BytesRef)this.fieldsData).bytes, dimension);
    }

    static long decodeMin(byte[] b, int dimension) {
        int offset = dimension * 8;
        return NumericUtils.sortableBytesToLong(b, offset);
    }

    static long decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 8;
        return NumericUtils.sortableBytesToLong(b, offset);
    }

    public static Query newIntersectsQuery(String field, long[] min, long[] max) {
        return LongRange.newRelationQuery(field, min, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, long[] min, long[] max) {
        return LongRange.newRelationQuery(field, min, max, RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, long[] min, long[] max) {
        return LongRange.newRelationQuery(field, min, max, RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, long[] min, long[] max) {
        return LongRange.newRelationQuery(field, min, max, RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, long[] min, long[] max, RangeFieldQuery.QueryType relation) {
        LongRange.checkArgs(min, max);
        return new RangeFieldQuery(field, LongRange.encode(min, max), min.length, relation){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return LongRange.toString(ranges, dimension);
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        LongRange.toString(b, 0);
        for (int d = 0; d < this.type.pointDataDimensionCount() / 2; ++d) {
            sb.append(' ');
            sb.append(LongRange.toString(b, d));
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Long.toString(LongRange.decodeMin(ranges, dimension)) + " : " + Long.toString(LongRange.decodeMax(ranges, dimension)) + "]";
    }
}

