/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class ExitableDirectoryReader
extends FilterDirectoryReader {
    private QueryTimeout queryTimeout;

    public ExitableDirectoryReader(DirectoryReader in, QueryTimeout queryTimeout) throws IOException {
        super(in, new ExitableSubReaderWrapper(queryTimeout));
        this.queryTimeout = queryTimeout;
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new ExitableDirectoryReader(in, this.queryTimeout);
    }

    public static DirectoryReader wrap(DirectoryReader in, QueryTimeout queryTimeout) throws IOException {
        return new ExitableDirectoryReader(in, queryTimeout);
    }

    @Override
    public String toString() {
        return "ExitableDirectoryReader(" + this.in.toString() + ")";
    }

    public static class ExitableFields
    extends FilterLeafReader.FilterFields {
        private QueryTimeout queryTimeout;

        public ExitableFields(Fields fields, QueryTimeout queryTimeout) {
            super(fields);
            this.queryTimeout = queryTimeout;
        }

        @Override
        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return new ExitableTerms(terms, this.queryTimeout);
        }
    }

    public static class ExitableFilterAtomicReader
    extends FilterLeafReader {
        private QueryTimeout queryTimeout;

        public ExitableFilterAtomicReader(LeafReader in, QueryTimeout queryTimeout) {
            super(in);
            this.queryTimeout = queryTimeout;
        }

        @Override
        public Fields fields() throws IOException {
            Fields fields = super.fields();
            if (this.queryTimeout.isTimeoutEnabled()) {
                return new ExitableFields(fields, this.queryTimeout);
            }
            return fields;
        }

        @Override
        public Object getCoreCacheKey() {
            return this.in.getCoreCacheKey();
        }

        @Override
        public Object getCombinedCoreAndDeletesKey() {
            return this.in.getCombinedCoreAndDeletesKey();
        }
    }

    public static class ExitableSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private QueryTimeout queryTimeout;

        public ExitableSubReaderWrapper(QueryTimeout queryTimeout) {
            this.queryTimeout = queryTimeout;
        }

        @Override
        public LeafReader wrap(LeafReader reader) {
            return new ExitableFilterAtomicReader(reader, this.queryTimeout);
        }
    }

    public static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private QueryTimeout queryTimeout;

        public ExitableTerms(Terms terms, QueryTimeout queryTimeout) {
            super(terms);
            this.queryTimeout = queryTimeout;
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryTimeout);
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryTimeout);
        }
    }

    public static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private QueryTimeout queryTimeout;

        public ExitableTermsEnum(TermsEnum termsEnum, QueryTimeout queryTimeout) {
            super(termsEnum);
            this.queryTimeout = queryTimeout;
            this.checkAndThrow();
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to iterate over terms. Timeout: " + this.queryTimeout.toString() + ", TermsEnum=" + this.in);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while iterating over terms. TermsEnum=" + this.in);
            }
        }

        @Override
        public BytesRef next() throws IOException {
            this.checkAndThrow();
            return this.in.next();
        }
    }

    public static class ExitingReaderException
    extends RuntimeException {
        ExitingReaderException(String msg) {
            super(msg);
        }
    }
}

