/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.SourcesChangeEvents;
import com.google.gwt.user.client.ui.impl.TextBoxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBoxBase
extends FocusWidget
implements SourcesChangeEvents,
HasChangeHandlers,
HasText,
HasName,
HasValue<String> {
    public static final TextAlignConstant ALIGN_CENTER = new TextAlignConstant("center");
    public static final TextAlignConstant ALIGN_JUSTIFY = new TextAlignConstant("justify");
    public static final TextAlignConstant ALIGN_LEFT = new TextAlignConstant("left");
    public static final TextAlignConstant ALIGN_RIGHT = new TextAlignConstant("right");
    private static TextBoxImpl impl = (TextBoxImpl)GWT.create(TextBoxImpl.class);
    private Event currentEvent;
    private boolean valueChangeHandlerInitialized;

    protected TextBoxBase(Element elem) {
        super(elem);
    }

    @Override
    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler(handler, ChangeEvent.getType());
    }

    @Override
    @Deprecated
    public void addChangeListener(ChangeListener listener) {
        this.addChangeHandler(new ListenerWrapper.WrappedChangeListener(listener));
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        if (!this.valueChangeHandlerInitialized) {
            this.valueChangeHandlerInitialized = true;
            this.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ValueChangeEvent.fire(TextBoxBase.this, TextBoxBase.this.getText());
                }
            });
        }
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    public void cancelKey() {
        if (this.currentEvent != null) {
            DOM.eventPreventDefault(this.currentEvent);
        }
    }

    public int getCursorPos() {
        return impl.getCursorPos(this.getElement());
    }

    @Override
    public String getName() {
        return DOM.getElementProperty(this.getElement(), "name");
    }

    public String getSelectedText() {
        int start = this.getCursorPos();
        if (start < 0) {
            return "";
        }
        int length = this.getSelectionLength();
        return this.getText().substring(start, start + length);
    }

    public int getSelectionLength() {
        return impl.getSelectionLength(this.getElement());
    }

    @Override
    public String getText() {
        return DOM.getElementProperty(this.getElement(), "value");
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    public boolean isReadOnly() {
        return DOM.getElementPropertyBoolean(this.getElement(), "readOnly");
    }

    @Override
    public void onBrowserEvent(Event event) {
        int type = DOM.eventGetType(event);
        if ((type & 0x380) != 0) {
            this.currentEvent = event;
            super.onBrowserEvent(event);
            this.currentEvent = null;
        } else {
            super.onBrowserEvent(event);
        }
    }

    @Override
    @Deprecated
    public void removeChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedChangeListener.remove(this, listener);
    }

    public void selectAll() {
        int length = this.getText().length();
        if (length > 0) {
            this.setSelectionRange(0, length);
        }
    }

    public void setCursorPos(int pos) {
        this.setSelectionRange(pos, 0);
    }

    @Deprecated
    public void setKey(char key) {
        if (this.currentEvent != null) {
            DOM.eventSetKeyCode(this.currentEvent, key);
        }
    }

    @Override
    public void setName(String name) {
        DOM.setElementProperty(this.getElement(), "name", name);
    }

    public void setReadOnly(boolean readOnly) {
        DOM.setElementPropertyBoolean(this.getElement(), "readOnly", readOnly);
        String readOnlyStyle = "readonly";
        if (readOnly) {
            this.addStyleDependentName(readOnlyStyle);
        } else {
            this.removeStyleDependentName(readOnlyStyle);
        }
    }

    public void setSelectionRange(int pos, int length) {
        if (!this.isAttached()) {
            return;
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length must be a positive integer. Length: " + length);
        }
        if (pos < 0 || length + pos > this.getText().length()) {
            throw new IndexOutOfBoundsException("From Index: " + pos + "  To Index: " + (pos + length) + "  Text Length: " + this.getText().length());
        }
        impl.setSelectionRange(this.getElement(), pos, length);
    }

    @Override
    public void setText(String text) {
        DOM.setElementProperty(this.getElement(), "value", text != null ? text : "");
    }

    public void setTextAlignment(TextAlignConstant align) {
        DOM.setStyleAttribute(this.getElement(), "textAlign", align.getTextAlignString());
    }

    @Override
    public void setValue(String value) {
        this.setValue(value, false);
    }

    @Override
    public void setValue(String value, boolean fireEvents) {
        String oldValue = this.getText();
        this.setText(value);
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual(this, oldValue, value);
        }
    }

    protected TextBoxImpl getImpl() {
        return impl;
    }

    public static class TextAlignConstant {
        private String textAlignString;

        private TextAlignConstant(String textAlignString) {
            this.textAlignString = textAlignString;
        }

        private String getTextAlignString() {
            return this.textAlignString;
        }
    }
}

