/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.RootPanel;

public class SimpleCheckBox
extends FocusWidget
implements HasName {
    public static SimpleCheckBox wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        SimpleCheckBox checkBox = new SimpleCheckBox(element);
        checkBox.onAttach();
        RootPanel.detachOnWindowClose(checkBox);
        return checkBox;
    }

    public SimpleCheckBox() {
        this(Document.get().createCheckInputElement(), "gwt-SimpleCheckBox");
    }

    protected SimpleCheckBox(Element element) {
        assert (InputElement.as(element).getType().equalsIgnoreCase("checkbox"));
        this.setElement(element);
    }

    SimpleCheckBox(Element element, String styleName) {
        this.setElement(element);
        if (styleName != null) {
            this.setStyleName(styleName);
        }
    }

    public String getName() {
        return this.getInputElement().getName();
    }

    public boolean isChecked() {
        String propName = this.isAttached() ? "checked" : "defaultChecked";
        return this.getInputElement().getPropertyBoolean(propName);
    }

    public void setChecked(boolean checked) {
        this.getInputElement().setChecked(checked);
        this.getInputElement().setDefaultChecked(checked);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.removeStyleDependentName("disabled");
        } else {
            this.addStyleDependentName("disabled");
        }
    }

    public void setName(String name) {
        this.getInputElement().setName(name);
    }

    protected void onUnload() {
        this.setChecked(this.isChecked());
    }

    private InputElement getInputElement() {
        return InputElement.as(this.getElement());
    }
}

