/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.Duration;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerImpl
extends Scheduler {
    public static final SchedulerImpl INSTANCE = (SchedulerImpl)GWT.create(SchedulerImpl.class);
    private static final int FLUSHER_DELAY = 1;
    private static final int RESCUE_DELAY = 50;
    private static final double TIME_SLICE = 100.0;
    final Scheduler.RepeatingCommand flusher = new Scheduler.RepeatingCommand(){

        public boolean execute() {
            SchedulerImpl.this.flushRunning = true;
            SchedulerImpl.this.flushPostEventPumpCommands();
            SchedulerImpl.this.flushRunning = false;
            return SchedulerImpl.this.shouldBeRunning = SchedulerImpl.this.isWorkQueued();
        }
    };
    final Scheduler.RepeatingCommand rescue = new Scheduler.RepeatingCommand(){

        public boolean execute() {
            if (SchedulerImpl.this.flushRunning) {
                SchedulerImpl.this.scheduleFixedDelay(SchedulerImpl.this.flusher, 1);
            }
            return SchedulerImpl.this.shouldBeRunning;
        }
    };
    JsArray<Task> deferredCommands = (JsArray)JavaScriptObject.createArray().cast();
    JsArray<Task> incrementalCommands = (JsArray)JavaScriptObject.createArray().cast();
    JsArray<Task> finallyCommands = (JsArray)JavaScriptObject.createArray().cast();
    private boolean shouldBeRunning = false;
    private boolean flushRunning = false;

    private static boolean execute(Scheduler.RepeatingCommand cmd) {
        return cmd.execute();
    }

    private static JsArray<Task> runRepeatingTasks(JsArray<Task> tasks) {
        boolean canceledSomeTasks = false;
        int length = tasks.length();
        double start = Duration.currentTimeMillis();
        while (Duration.currentTimeMillis() - start < 100.0) {
            for (int i = 0; i < length; ++i) {
                assert (tasks.length() == length) : "Working array length changed " + tasks.length() + " != " + length;
                Task t = tasks.get(i);
                if (t == null) continue;
                assert (t.isRepeating()) : "Found a non-repeating Task";
                if (t.executeRepeating()) continue;
                tasks.set(i, null);
                canceledSomeTasks = true;
            }
        }
        if (canceledSomeTasks) {
            JsArray newTasks = (JsArray)JavaScriptObject.createArray().cast();
            for (int i = 0; i < length; ++i) {
                if (tasks.get(i) == null) continue;
                newTasks.push(tasks.get(i));
            }
            assert (newTasks.length() < length);
            return newTasks;
        }
        return tasks;
    }

    private static void runScheduledTasks(JsArray<Task> tasks, JsArray<Task> rescheduled) {
        int j = tasks.length();
        for (int i = 0; i < j; ++i) {
            assert (tasks.length() == j) : "Working array length changed " + tasks.length() + " != " + j;
            Task t = tasks.get(i);
            try {
                if (t.isRepeating()) {
                    if (!t.executeRepeating()) continue;
                    rescheduled.push(t);
                    continue;
                }
                t.executeScheduled();
                continue;
            }
            catch (RuntimeException e) {
                if (GWT.getUncaughtExceptionHandler() == null) continue;
                GWT.getUncaughtExceptionHandler().onUncaughtException(e);
            }
        }
    }

    private static native void scheduleFixedDelayImpl(Scheduler.RepeatingCommand var0, int var1);

    private static native void scheduleFixedPeriodImpl(Scheduler.RepeatingCommand var0, int var1);

    public void flushFinallyCommands() {
        JsArray<Task> oldFinally = this.finallyCommands;
        this.finallyCommands = (JsArray)JavaScriptObject.createArray().cast();
        SchedulerImpl.runScheduledTasks(oldFinally, this.finallyCommands);
    }

    @Override
    public void scheduleDeferred(Scheduler.ScheduledCommand cmd) {
        this.deferredCommands.push(Task.create(cmd));
        this.maybeSchedulePostEventPumpCommands();
    }

    @Override
    public void scheduleFinally(Scheduler.ScheduledCommand cmd) {
        this.finallyCommands.push(Task.create(cmd));
    }

    @Override
    public void scheduleFixedDelay(Scheduler.RepeatingCommand cmd, int delayMs) {
        SchedulerImpl.scheduleFixedDelayImpl(cmd, delayMs);
    }

    @Override
    public void scheduleFixedPeriod(Scheduler.RepeatingCommand cmd, int delayMs) {
        SchedulerImpl.scheduleFixedPeriodImpl(cmd, delayMs);
    }

    @Override
    public void scheduleIncremental(Scheduler.RepeatingCommand cmd) {
        this.deferredCommands.push(Task.create(cmd));
        this.maybeSchedulePostEventPumpCommands();
    }

    void flushPostEventPumpCommands() {
        JsArray<Task> oldDeferred = this.deferredCommands;
        this.deferredCommands = (JsArray)JavaScriptObject.createArray().cast();
        SchedulerImpl.runScheduledTasks(oldDeferred, this.incrementalCommands);
        this.incrementalCommands = SchedulerImpl.runRepeatingTasks(this.incrementalCommands);
    }

    boolean isWorkQueued() {
        return this.deferredCommands.length() > 0 || this.incrementalCommands.length() > 0;
    }

    private void maybeSchedulePostEventPumpCommands() {
        if (!this.shouldBeRunning) {
            this.shouldBeRunning = true;
            SchedulerImpl.scheduleFixedDelayImpl(this.flusher, 1);
            SchedulerImpl.scheduleFixedDelayImpl(this.rescue, 50);
        }
    }

    static final class Task
    extends JavaScriptObject {
        public static native Task create(Scheduler.RepeatingCommand var0);

        public static native Task create(Scheduler.ScheduledCommand var0);

        protected Task() {
        }

        public boolean executeRepeating() {
            return this.getRepeating().execute();
        }

        public void executeScheduled() {
            this.getScheduled().execute();
        }

        public native Scheduler.RepeatingCommand getRepeating();

        public native Scheduler.ScheduledCommand getScheduled();

        public native boolean isRepeating();
    }
}

