/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.model;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.xml.Messages;
import org.eclipse.wb.internal.core.xml.editor.palette.command.CategoryAddCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.ComponentAddCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.model.CategoryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.ComponentEntryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.IPaletteSite;
import org.eclipse.wb.internal.core.xml.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.ToolEntryInfo;

public final class ChooseComponentEntryInfo
extends ToolEntryInfo {
    private static final Image ICON = DesignerPlugin.getImage((String)"palette/ChooseComponent.gif");

    public ChooseComponentEntryInfo() {
        this.setName(Messages.ChooseComponentEntryInfo_name);
        this.setDescription(Messages.ChooseComponentEntryInfo_description);
    }

    public Image getIcon() {
        return ICON;
    }

    public Tool createTool() throws Exception {
        Shell parentShell = IPaletteSite.Helper.getSite(this.m_rootJavaInfo).getShell();
        String componentClassName = JdtUiUtils.selectTypeName((Shell)parentShell, (IJavaProject)this.m_javaProject);
        if (componentClassName != null) {
            ComponentEntryInfo componentEntry = new ComponentEntryInfo();
            componentEntry.setId("custom_" + System.currentTimeMillis());
            componentEntry.setName(CodeUtils.getShortClass((String)componentClassName));
            componentEntry.setDescription(MessageFormat.format(Messages.ChooseComponentEntryInfo_newDescription, componentClassName));
            componentEntry.setComponentClassName(componentClassName);
            if (componentEntry.initialize(this.m_editPartViewer, this.m_rootJavaInfo)) {
                this.addChosenComponent(componentEntry);
                return componentEntry.createTool();
            }
        }
        return null;
    }

    private void addChosenComponent(ComponentEntryInfo entry) {
        if (DesignerPlugin.getPreferences().getBoolean("common.addChosenComponentsToPalette")) {
            CategoryInfo category = this.getCustomCategory();
            ComponentAddCommand command = new ComponentAddCommand(entry.getId(), entry.getName(), entry.getDescription(), true, entry.getClassName(), category);
            this.getSite().addCommand(command);
        }
    }

    private CategoryInfo getCustomCategory() {
        PaletteInfo palette = this.getSite().getPalette();
        List<CategoryInfo> categories = palette.getCategories();
        for (CategoryInfo category : categories) {
            if (!"Custom".equals(category.getName())) continue;
            return category;
        }
        this.getSite().addCommand(new CategoryAddCommand("category_" + System.currentTimeMillis(), "Custom", Messages.ChooseComponentEntryInfo_customCategoryDescription, true, true, null));
        return this.getCustomCategory();
    }
}

