/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.sdm.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDMDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.debug.sdm.core";
    public static final String SDM_DEBUGGER_EXTENSION_POINT_ID = "SDMDebugger";
    public static final String DEBUGGER_ELEMENT = "debugger";
    private static final String EMPTY_STRING = "";
    private static final String ATTR_SDM_PATH = "sdmPath";
    private static final String ATTR_PRIORITY = "priority";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_BACKEND_PATH = "backendPath";
    private static final String ATTR_USE_BUILTIN = "useBuiltin";
    private static SDMDebugCorePlugin plugin;
    private Map<String, String> debuggerBackends = null;
    private Map<String, String> debuggerBackendPaths = null;
    private Map<String, Boolean> debuggerUseBuiltin = null;
    private Map<String, String> debuggerSDMPaths = null;

    public static SDMDebugCorePlugin getDefault() {
        return plugin;
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = plugin.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public SDMDebugCorePlugin() {
        plugin = this;
    }

    private int compare(String p1, String p2) {
        int pri1 = 0;
        int pri2 = 0;
        try {
            pri1 = Integer.parseInt(p1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            pri2 = Integer.parseInt(p2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return pri1 - pri2;
    }

    public String getDebuggerBackendPath(String backend) {
        this.initializeDebuggerBackends();
        return this.debuggerBackendPaths.get(backend);
    }

    public String[] getDebuggerBackends() {
        this.initializeDebuggerBackends();
        String[] backends = this.debuggerBackends.keySet().toArray(new String[this.debuggerBackends.size()]);
        Arrays.sort(backends, new BackendSorter());
        return backends;
    }

    public String getDebuggerSDMPath(String backend) {
        this.initializeDebuggerBackends();
        return this.debuggerSDMPaths.get(backend);
    }

    public boolean getDebuggerUseBuiltin(String backend) {
        this.initializeDebuggerBackends();
        Boolean useBuiltin = this.debuggerUseBuiltin.get(backend);
        if (useBuiltin != null) {
            return useBuiltin;
        }
        return false;
    }

    private void initializeDebuggerBackends() {
        if (this.debuggerBackends == null) {
            IConfigurationElement[] configs;
            this.debuggerBackends = new HashMap<String, String>();
            this.debuggerBackendPaths = new HashMap<String, String>();
            this.debuggerUseBuiltin = new HashMap<String, Boolean>();
            this.debuggerSDMPaths = new HashMap<String, String>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(SDMDebugCorePlugin.getUniqueIdentifier(), SDM_DEBUGGER_EXTENSION_POINT_ID);
            IConfigurationElement[] iConfigurationElementArray = configs = extensionPoint.getConfigurationElements();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if (configurationElement.getName().equals(DEBUGGER_ELEMENT)) {
                    String backend;
                    String oldPriority;
                    String newPriority = configurationElement.getAttribute(ATTR_PRIORITY);
                    if (newPriority == null) {
                        newPriority = "0";
                    }
                    if ((oldPriority = this.debuggerBackends.get(backend = configurationElement.getAttribute(ATTR_NAME))) == null || this.compare(newPriority, oldPriority) > 0) {
                        this.debuggerBackends.put(backend, newPriority);
                        String path = configurationElement.getAttribute(ATTR_BACKEND_PATH);
                        this.debuggerBackendPaths.put(backend, path == null ? EMPTY_STRING : path);
                        String sdmPath = configurationElement.getAttribute(ATTR_SDM_PATH);
                        this.debuggerSDMPaths.put(backend, sdmPath == null ? EMPTY_STRING : sdmPath);
                        String useBuiltin = configurationElement.getAttribute(ATTR_USE_BUILTIN);
                        if (useBuiltin != null) {
                            this.debuggerUseBuiltin.put(backend, Boolean.valueOf(useBuiltin));
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackendSorter
    implements Comparator<String> {
        private BackendSorter() {
        }

        @Override
        public int compare(String o1, String o2) {
            int pri1 = 0;
            try {
                pri1 = Integer.parseInt((String)SDMDebugCorePlugin.this.debuggerBackends.get(o1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int pri2 = 0;
            try {
                pri2 = Integer.parseInt((String)SDMDebugCorePlugin.this.debuggerBackends.get(o2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return pri2 - pri1;
        }
    }
}

