/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.internal.debug.core.zend.communication.CommunicationUtilities;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugMessageResponseImpl;

public class GetCodeCoverageResponse
extends DebugMessageResponseImpl
implements IDebugResponseMessage {
    private CodeCoverageData[] fCodeCoverageData;
    protected static boolean isDebugMode = System.getProperty("loggingDebug") != null;

    public CodeCoverageData[] getCodeCoverageData() {
        return this.fCodeCoverageData;
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        this.setID(in.readInt());
        int numFiles = in.readInt();
        this.fCodeCoverageData = new CodeCoverageData[numFiles];
        int i = 0;
        while (i < numFiles) {
            String fileName = CommunicationUtilities.readString(in);
            if (isDebugMode) {
                System.out.println("Covered file: " + fileName);
            }
            int numberOfLines = in.readInt();
            if (isDebugMode) {
                System.out.println("Number of lines (1): " + numberOfLines);
            }
            int numberOfBytes = numberOfLines / 8 + 1;
            if (isDebugMode) {
                System.out.println("Number of bytes (1): " + numberOfBytes);
            }
            byte[] coverageBitmask = new byte[numberOfBytes];
            int j = 0;
            while (j < numberOfBytes) {
                coverageBitmask[j] = in.readByte();
                ++j;
            }
            this.fCodeCoverageData[i] = new CodeCoverageData(fileName, numberOfLines, coverageBitmask);
            int numberOfLines2 = in.readInt();
            if (isDebugMode) {
                System.out.println("Number of lines (2): " + numberOfLines2);
            }
            if (numberOfLines != numberOfLines2) {
                throw new IOException("Old format code coverage responce.");
            }
            numberOfBytes = numberOfLines / 8 + 1;
            if (isDebugMode) {
                System.out.println("Number of bytes (2): " + numberOfBytes);
            }
            byte[] significanceBitmask = new byte[numberOfBytes];
            int j2 = 0;
            while (j2 < numberOfBytes) {
                significanceBitmask[j2] = in.readByte();
                ++j2;
            }
            this.fCodeCoverageData[i].setSignificanceBitmask(significanceBitmask);
            int numberOfPHPLines = in.readInt();
            if (isDebugMode) {
                System.out.println("Number of php lines: " + numberOfPHPLines);
            }
            this.fCodeCoverageData[i].setPHPLinesNum(numberOfPHPLines);
            ++i;
        }
    }

    @Override
    public int getType() {
        return 11014;
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        out.writeShort(this.getType());
        out.writeInt(this.getID());
        out.writeInt(this.getStatus());
    }
}

