/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracXmlRpcClient;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;

public class TracRenderingEngine
extends AbstractRenderingEngine {
    public String renderAsHtml(TaskRepository repository, String text, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Render HTML Preview", -1);
        try {
            ITracClient client = TracCorePlugin.getDefault().getConnector().getClientManager().getTracClient(repository);
            if (client instanceof TracXmlRpcClient) {
                String html;
                TracXmlRpcClient tracXmlRpcClient = (TracXmlRpcClient)client;
                String htmlText = tracXmlRpcClient.wikiToHtml(text, monitor);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                String htmlHeader = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\"><head><link rel=\"stylesheet\" href=\"REPOSITORY_URL/chrome/common/css/trac.css\" type=\"text/css\" /><link rel=\"stylesheet\" href=\"REPOSITORY_URL/chrome/common/css/wiki.css\" type=\"text/css\" /><link rel=\"icon\" href=\"REPOSITORY_URL/chrome/common/trac.ico\" type=\"image/x-icon\" /><link rel=\"shortcut icon\" href=\"EPOSITORY_URL/chrome/common/trac.ico\" type=\"image/x-icon\" /><style type=\"text/css\">body {background: #f4f4f4 url(REPOSITORY_URL/chrome/common/draft.png);margin: 0;padding: 0;}</style></head>";
                String htmlBody = "<body> " + htmlText + "</body>";
                String htmlFooter = "</html>";
                String string = html = String.valueOf(htmlHeader.replace("REPOSITORY_URL", repository.getRepositoryUrl())) + htmlBody + htmlFooter;
                return string;
            }
            try {
                throw new CoreException(TracCorePlugin.toStatus((Throwable)new TracException("Preview is available only in XML-RPC access mode"), (TaskRepository)repository));
            }
            catch (TracException e) {
                throw new CoreException(TracCorePlugin.toStatus((Throwable)e, (TaskRepository)repository));
            }
        }
        finally {
            monitor.done();
        }
    }
}

