/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.mavenarchiver;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WarPluginConfiguration;
import org.eclipse.m2e.wtp.mavenarchiver.AbstractWTPArchiverConfigurator;

public class WarMavenArchiverConfigurator
extends AbstractWTPArchiverConfigurator {
    protected IPath getOutputDir(IMavenProjectFacade facade) {
        IProject project = facade.getProject();
        MavenProject mavenProject = facade.getMavenProject();
        WarPluginConfiguration warPluginConfiguration = new WarPluginConfiguration(mavenProject, project);
        if (MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().getPreferences(project).isWebMavenArchiverUsesBuildDirectory() || warPluginConfiguration.getWebResources() != null && warPluginConfiguration.getWebResources().length > 0 || warPluginConfiguration.isFilteringDeploymentDescriptorsEnabled()) {
            IPath localResourceFolder = ProjectUtils.getM2eclipseWtpFolder(mavenProject, project);
            return project.getFullPath().append(localResourceFolder).append("web-resources");
        }
        return project.getFolder(warPluginConfiguration.getWarSourceDirectory()).getFullPath();
    }

    protected String getArchiverFieldName() {
        return "warArchiver";
    }

    protected MojoExecutionKey getExecutionKey() {
        MojoExecutionKey key = new MojoExecutionKey("org.apache.maven.plugins", "maven-war-plugin", "", "war", null, null);
        return key;
    }
}

