/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.libra.warproducts.core.validation.Validator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.product.PluginSection;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyCalculator;
import org.eclipse.swt.widgets.Composite;

public class PluginSectionExtended
extends PluginSection {
    private static final int BUTTON_ADD_REQUIRED = 2;

    public PluginSectionExtended(PDEFormPage formPage, Composite parent) {
        super(formPage, parent);
    }

    protected void buttonSelected(int index) {
        if (index == 2) {
            PDEFormEditor pdeEditor = this.getPage().getPDEEditor();
            IProductModel model = (IProductModel)pdeEditor.getAggregateModel();
            this.validHandleAddRequired(model.getProduct().getPlugins(), this.includeOptionalDependencies());
        } else {
            super.buttonSelected(index);
        }
    }

    private void validHandleAddRequired(IProductPlugin[] plugins, boolean includeOptional) {
        if (plugins.length > 0) {
            ArrayList<BundleDescription> list = new ArrayList<BundleDescription>(plugins.length);
            int i = 0;
            while (i < plugins.length) {
                list.add(TargetPlatformHelper.getState().getBundle(plugins[i].getId(), null));
                ++i;
            }
            DependencyCalculator calculator = new DependencyCalculator(includeOptional);
            calculator.findDependencies(list.toArray());
            BundleDescription[] bundles = TargetPlatformHelper.getState().getBundles();
            int i2 = 0;
            while (i2 < bundles.length) {
                HostSpecification host = bundles[i2].getHost();
                String compatibilityId = "org.eclipse.ui.workbench.compatibility";
                String bundleName = bundles[i2].getSymbolicName();
                boolean compatible = compatibilityId.equals(bundleName);
                if (host != null) {
                    String hostName = host.getName();
                    boolean containsPluginId = calculator.containsPluginId(hostName);
                    if (!compatible && containsPluginId) {
                        calculator.findDependency((Object)bundles[i2]);
                    }
                }
                ++i2;
            }
            List dependencies = this.validateBundleIds(calculator.getBundleIDs());
            this.validateBundleIds(dependencies);
            IProduct product = plugins[0].getProduct();
            IProductModelFactory factory = product.getModel().getFactory();
            IProductPlugin[] requiredPlugins = new IProductPlugin[dependencies.size()];
            int i3 = 0;
            while (i3 < requiredPlugins.length) {
                String id = (String)dependencies.get(i3);
                IProductPlugin plugin = factory.createPlugin();
                plugin.setId(id);
                requiredPlugins[i3] = plugin;
                ++i3;
            }
            product.addPlugins(requiredPlugins);
        }
    }

    private List validateBundleIds(Collection bundleIDs) {
        ArrayList validBundles = new ArrayList();
        this.copyBundleIds(bundleIDs, validBundles);
        this.handleBannedBundles(validBundles);
        this.handleRequiredBundles(validBundles);
        return validBundles;
    }

    private void copyBundleIds(Collection bundleIDs, List validBundles) {
        Iterator iter = bundleIDs.iterator();
        while (iter.hasNext()) {
            validBundles.add(iter.next());
        }
    }

    private void handleRequiredBundles(Collection bundleIDs) {
        String[] requiredBundles = Validator.REQUIRED_BUNDLES;
        int i = 0;
        while (i < requiredBundles.length) {
            String requiredId = requiredBundles[i];
            if (!bundleIDs.contains(requiredId)) {
                bundleIDs.add(requiredId);
            }
            ++i;
        }
    }

    private void handleBannedBundles(Collection bundleIDs) {
        String[] bannedBundles = Validator.BANNED_BUNDLES;
        int i = 0;
        while (i < bannedBundles.length) {
            String bannedId = bannedBundles[i];
            if (bundleIDs.contains(bannedId)) {
                bundleIDs.remove(bannedId);
            }
            ++i;
        }
    }
}

