/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class WEActionHandler
extends AbstractHandler
implements ISelectionListener {
    private boolean requiresOpenEditor;
    private boolean enabled;

    public WEActionHandler(boolean requiresOpenEditor) {
        this.setRequiresOpenEditor(requiresOpenEditor);
        if (this.isRequiresOpenEditor()) {
            final WEActionHandler theInstance = this;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)theInstance);
                        Object selection = GeneralHelper.getActiveInstance() != null ? GeneralHelper.getActiveInstance().getSelectionProvider().getSelection() : new StructuredSelection();
                        WEActionHandler.this.selectionChanged(null, (ISelection)selection);
                    } else {
                        WEActionHandler.this.setEnabled(false);
                    }
                }
            });
        } else {
            this.setEnabled(true);
        }
    }

    public boolean isRequiresOpenEditor() {
        return this.requiresOpenEditor;
    }

    private void setRequiresOpenEditor(boolean requiresOpenEditor) {
        this.requiresOpenEditor = requiresOpenEditor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
        }
    }

    private void refreshEnabledState() {
        if (GeneralHelper.getActiveInstance() != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.refreshEnabledState();
    }

    public void dispose() {
        super.dispose();
        if (this.isRequiresOpenEditor() && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
    }
}

