/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Profile;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

@Entity
@Table(name="OM_PROFILE")
class ObjectMappingProfilePO
implements IObjectMappingProfilePO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedRest {
    private transient Long m_id = null;
    private transient Integer m_version = null;
    private double m_nameFactor = 0.0;
    private double m_pathFactor = 0.0;
    private double m_contextFactor = 0.0;
    private double m_threshold = 0.0;
    private final PropertyChangeSupport m_pcs = new PropertyChangeSupport(this);
    static final long serialVersionUID = 8810685609528598809L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    ObjectMappingProfilePO() {
    }

    @Basic
    @Column(name="CONTEXT_FACTOR")
    private double getHbmContextFactor() {
        return this.m_contextFactor;
    }

    @Basic
    @Column(name="NAME_FACTOR")
    private double getHbmNameFactor() {
        return this.m_nameFactor;
    }

    @Basic
    @Column(name="PATH_FACTOR")
    private double getHbmPathFactor() {
        return this.m_pathFactor;
    }

    @Override
    @Basic
    @Column(name="THRESHOLD")
    public double getThreshold() {
        return this.m_threshold;
    }

    private void setHbmContextFactor(double contextFactor) {
        double oldValue = this.m_contextFactor;
        this.m_contextFactor = contextFactor;
        this.m_pcs.firePropertyChange("contextFactor", oldValue, this.m_contextFactor);
    }

    private void setHbmNameFactor(double nameFactor) {
        double oldValue = this.m_nameFactor;
        this.m_nameFactor = nameFactor;
        this.m_pcs.firePropertyChange("nameFactor", oldValue, this.m_nameFactor);
    }

    private void setHbmPathFactor(double pathFactor) {
        double oldValue = this.m_pathFactor;
        this.m_pathFactor = pathFactor;
        this.m_pcs.firePropertyChange("pathFactor", oldValue, this.m_pathFactor);
    }

    @Override
    public void setThreshold(double threshold) {
        double oldValue = this.m_threshold;
        this.m_threshold = threshold;
        this.m_pcs.firePropertyChange("threshold", oldValue, this.m_threshold);
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    @Override
    @Transient
    public String getName() {
        return null;
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    @Override
    @Transient
    public Long getParentProjectId() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " " + Messages.DoesNotHaveAParentProject);
    }

    @Override
    public void setParentProjectId(Long projectId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " " + Messages.DoesNotHaveAParentProject);
    }

    private void setId(Long id) {
        this.m_id = id;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    public void useTemplate(Profile template) {
        this.setContextFactor(template.getContextFactor());
        this.setNameFactor(template.getNameFactor());
        this.setPathFactor(template.getPathFactor());
        this.setThreshold(template.getThreshold());
    }

    @Override
    public boolean matchesTemplate(Profile template) {
        return this.getContextFactor() == template.getContextFactor() && this.getNameFactor() == template.getNameFactor() && this.getPathFactor() == template.getPathFactor() && this.getThreshold() == template.getThreshold();
    }

    @Override
    @Transient
    public double getPathFactor() {
        return this.getHbmPathFactor();
    }

    @Override
    @Transient
    public double getContextFactor() {
        return this.getHbmContextFactor();
    }

    @Override
    @Transient
    public double getNameFactor() {
        return this.getHbmNameFactor();
    }

    @Override
    public void setPathFactor(double pathFactor) {
        this.validateFactor(pathFactor);
        this.setHbmPathFactor(pathFactor);
    }

    @Override
    public void setContextFactor(double contextFactor) {
        this.validateFactor(contextFactor);
        this.setHbmContextFactor(contextFactor);
    }

    @Override
    public void setNameFactor(double nameFactor) {
        this.validateFactor(nameFactor);
        this.setHbmNameFactor(nameFactor);
    }

    private void validateFactor(double factorValue) throws IllegalArgumentException {
        Validate.isTrue((factorValue >= 0.0 ? 1 : 0) != 0);
        Validate.isTrue((factorValue <= 1.0 ? 1 : 0) != 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IObjectMappingProfilePO) {
            IObjectMappingProfilePO profile = (IObjectMappingProfilePO)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)profile.getName()).append(this.getNameFactor(), profile.getNameFactor()).append(this.getContextFactor(), profile.getContextFactor()).append(this.getPathFactor(), profile.getPathFactor()).append(this.getThreshold(), profile.getThreshold()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.getName());
        hcb.append(this.getNameFactor());
        hcb.append(this.getContextFactor());
        hcb.append(this.getPathFactor());
        hcb.append(this.getThreshold());
        return hcb.toHashCode();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_pcs.removePropertyChangeListener(listener);
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ObjectMappingProfilePO();
    }

    public Object _persistence_get(String string) {
        if (string == "hbmPathFactor") {
            return this.hbmPathFactor;
        }
        if (string == "hbmNameFactor") {
            return this.hbmNameFactor;
        }
        if (string == "threshold") {
            return this.threshold;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "hbmContextFactor") {
            return this.hbmContextFactor;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "hbmPathFactor") {
            this.hbmPathFactor = (Double)object;
            return;
        }
        if (string == "hbmNameFactor") {
            this.hbmNameFactor = (Double)object;
            return;
        }
        if (string == "threshold") {
            this.threshold = (Double)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "hbmContextFactor") {
            this.hbmContextFactor = (Double)object;
            return;
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

