/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.internal.resource.ModuleResourceLocator;

public class WebModuleResourceLocator
extends ModuleResourceLocator {
    protected static final IPath WEB_INF_CLASSES_PATH = new Path("WEB-INF/classes");
    protected static final IPath WEB_META_INF_PATH = WEB_INF_CLASSES_PATH.append(META_INF_PATH);

    @Override
    public IContainer getDefaultLocation(IProject project) {
        return this.getRootFolder(project).getFolder(WEB_META_INF_PATH).getUnderlyingFolder();
    }

    @Override
    public IPath getWorkspacePath(IProject project, IPath runtimePath) {
        return super.getWorkspacePath(project, WEB_INF_CLASSES_PATH.append(runtimePath));
    }

    @Override
    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        IPath runtimePath = super.getRuntimePath(project, resourcePath);
        return WEB_INF_CLASSES_PATH.isPrefixOf(runtimePath) ? runtimePath.makeRelativeTo(WEB_INF_CLASSES_PATH) : runtimePath;
    }
}

