/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.wireadmin;

import java.util.AbstractCollection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.wireadmin.Activator;
import org.eclipse.equinox.internal.wireadmin.NotificationEvent;
import org.eclipse.equinox.internal.wireadmin.WireAdminImpl;
import org.eclipse.equinox.internal.wireadmin.WireProperties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.wireadmin.Consumer;
import org.osgi.service.wireadmin.Envelope;
import org.osgi.service.wireadmin.Producer;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireConstants;
import org.osgi.service.wireadmin.WirePermission;

class WireImpl
implements Wire,
ServiceListener {
    private BundleContext bc;
    private WireProperties properties;
    ServiceReference producerRef;
    ServiceReference consumerRef;
    private Producer producer;
    private Consumer consumer;
    private Class[] flavors;
    private Object lastValue;
    private Object previousValue;
    private Vector envelopes;
    private WireAdminImpl parent;
    private Filter filter = null;
    private long previousUpdateTime = -1L;
    private Hashtable wireValues;
    private String[] scope;
    boolean isValid = true;
    private boolean interoperate = true;
    private boolean allAccepted = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    WireImpl(BundleContext bc, WireAdminImpl parent, Dictionary properties) {
        this.bc = bc;
        this.parent = parent;
        this.properties = new WireProperties();
        Enumeration en = properties.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            this.properties.put0(key, properties.get(key));
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public Class[] getFlavors() {
        return this.isConnected() ? this.flavors : null;
    }

    public Dictionary getProperties() {
        return this.properties;
    }

    public synchronized Object getLastValue() {
        return this.lastValue;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void update(Object value) {
        block26: {
            if (!(this.isConnected() && this.interoperate && this.isAcceptable(value))) {
                return;
            }
            if (value instanceof Envelope && !this.hasScope((e = (Envelope)value).getScope())) {
                if (Activator.LOG_DEBUG) {
                    Activator.log.debug("[WireAdmin]: Try to pass a value in an Envelop without permission, silent return.", null);
                }
                return;
            }
            try {
                block27: {
                    if (this.filter == null) break block27;
                    this.wireValues.put("wirevalue.current", value);
                    if (this.previousValue != null) {
                        this.wireValues.put("wirevalue.previous", this.previousValue);
                        this.wireValues.put("wirevalue.elapsed", new Long(System.currentTimeMillis() - this.previousUpdateTime));
                    } else {
                        this.previousValue = value;
                    }
                    if ((v0 = WireImpl.class$0) == null) {
                        try {
                            v0 = WireImpl.class$0 = Class.forName("java.lang.Number");
                        }
                        catch (ClassNotFoundException v1) {
                            throw new NoClassDefFoundError(v1.getMessage());
                        }
                    }
                    if (!v0.isInstance(value)) ** GOTO lbl-1000
                    v2 = WireImpl.class$0;
                    if (v2 == null) {
                        try {
                            v2 = WireImpl.class$0 = Class.forName("java.lang.Number");
                        }
                        catch (ClassNotFoundException v3) {
                            throw new NoClassDefFoundError(v3.getMessage());
                        }
                    }
                    if (v2.isInstance(this.previousValue)) {
                        val = ((Number)value).doubleValue();
                        prevVal = ((Number)this.previousValue).doubleValue();
                        this.wireValues.put("wirevalue.delta.absolute", new Double(Math.abs(val - prevVal)));
                        this.wireValues.put("wirevalue.delta.relative", new Double(Math.abs(1.0 - prevVal / val)));
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.wireValues.remove("wirevalue.delta.absolute");
                        this.wireValues.remove("wirevalue.delta.relative");
                    }
                    if (!this.filter.match((Dictionary)this.wireValues)) {
                        if (Activator.LOG_DEBUG) {
                            Activator.log.debug(0, 10012, this.filter + " / " + value, null, false);
                        }
                        return;
                    }
                }
                if (this.consumer == null) break block26;
                try {
                    try {
                        this.consumer.updated((Wire)this, value);
                    }
                    catch (Throwable t) {
                        this.parent.notifyListeners(this, 2, t);
                        this.previousValue = value;
                        this.previousUpdateTime = System.currentTimeMillis();
                        this.parent.notifyListeners(this, 128, null);
                    }
                }
                finally {
                    this.previousValue = value;
                    this.previousUpdateTime = System.currentTimeMillis();
                    this.parent.notifyListeners(this, 128, null);
                }
            }
            finally {
                this.lastValue = value;
            }
        }
    }

    public synchronized Object poll() {
        Object[] value = null;
        if (this.isConnected() && this.interoperate) {
            try {
                value = this.producer.polled((Wire)this);
            }
            catch (Throwable t) {
                this.parent.notifyListeners(this, 1, t);
                return null;
            }
            this.parent.notifyListeners(this, 128, null);
            if (!this.isAcceptable(value) && !(value instanceof Envelope[])) {
                value = null;
            }
        }
        if (value != null) {
            this.lastValue = value;
            if (value instanceof Envelope[]) {
                if (this.allAccepted) {
                    return value;
                }
                Envelope[] envs = (Envelope[])value;
                if (this.scope == null) {
                    return value;
                }
                if (this.envelopes == null) {
                    this.envelopes = new Vector(envs.length);
                }
                boolean changed = false;
                int i = 0;
                while (i < envs.length) {
                    if (this.hasScope(envs[i].getScope())) {
                        this.envelopes.addElement(envs[i]);
                    } else {
                        changed = true;
                    }
                    ++i;
                }
                if (changed) {
                    value = new Envelope[this.envelopes.size()];
                    this.envelopes.copyInto(value);
                    this.envelopes.removeAllElements();
                }
            }
        }
        return value;
    }

    public boolean isConnected() {
        return this.isValid && this.consumerRef != null && this.producerRef != null;
    }

    public synchronized String[] getScope() {
        return this.scope;
    }

    private void setScope() {
        if (this.producerRef == null || this.consumerRef == null) {
            return;
        }
        Vector prodScope = WireImpl.checkPermission((String[])this.producerRef.getProperty("wireadmin.producer.scope"), "produce", this.producerRef.getBundle());
        Vector consScope = WireImpl.checkPermission((String[])this.consumerRef.getProperty("wireadmin.consumer.scope"), "consume", this.consumerRef.getBundle());
        if (prodScope == null || consScope == null) {
            return;
        }
        if (consScope.size() == 1 && consScope.elementAt(0).equals("*")) {
            this.scope = new String[prodScope.size()];
            prodScope.copyInto(this.scope);
            return;
        }
        if (prodScope.size() != ((String[])this.producerRef.getProperty("wireadmin.producer.scope")).length || consScope.size() != ((String[])this.consumerRef.getProperty("wireadmin.consumer.scope")).length) {
            this.allAccepted = false;
        }
        Vector cloning = (Vector)prodScope.clone();
        Enumeration en = cloning.elements();
        while (en.hasMoreElements()) {
            Object next = en.nextElement();
            if (((AbstractCollection)consScope).contains(next)) continue;
            prodScope.removeElement(next);
            this.allAccepted = false;
        }
        this.scope = new String[prodScope.size()];
        prodScope.copyInto(this.scope);
    }

    private static Vector checkPermission(String[] scope, String action, Bundle b) {
        if (scope == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < scope.length) {
            WirePermission wp = new WirePermission(scope[i], action);
            if (b.hasPermission((Object)wp)) {
                v.addElement(scope[i]);
            }
            ++i;
        }
        return v;
    }

    public boolean hasScope(String name) {
        if (this.scope == null || this.scope.length == 1 && this.scope[0].equals("*")) {
            return true;
        }
        int i = 0;
        while (i < this.scope.length) {
            if (name.equals(this.scope[i]) || this.scope[i].equals(WireConstants.WIREADMIN_SCOPE_ALL[0])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("Wire[PID=");
        sb.append(this.properties.get("wireadmin.pid"));
        sb.append(";prodPID=");
        sb.append(this.properties.get("wireadmin.producer.pid"));
        sb.append(";consPID=");
        sb.append(this.properties.get("wireadmin.consumer.pid"));
        sb.append(";connected=");
        sb.append(this.isConnected());
        sb.append("}]");
        return ((Object)sb).toString();
    }

    synchronized void start() {
        Class<?> clazz;
        ServiceReference ref;
        String producerPID = (String)this.properties.get("wireadmin.producer.pid");
        String consumerPID = (String)this.properties.get("wireadmin.consumer.pid");
        this.updateListenerFilter();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.wireadmin.Producer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ref = this.getSingleRef(clazz2.getName(), producerPID)) != null) {
            this.serviceRegistered(ref);
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.wireadmin.Consumer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ref = this.getSingleRef(clazz.getName(), consumerPID)) != null) {
            this.serviceRegistered(ref);
        }
        if (Activator.LOG_DEBUG) {
            Activator.log.debug(0, 10013, this.properties.get("wireadmin.pid").toString(), null, false);
        }
    }

    void updateListenerFilter() {
        String producerPID = WireImpl.escapeSpecialCharacters((String)this.properties.get("wireadmin.producer.pid"));
        String consumerPID = WireImpl.escapeSpecialCharacters((String)this.properties.get("wireadmin.consumer.pid"));
        try {
            Long id;
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            sb.append('|');
            sb.append('(').append('&');
            sb.append('(').append("service.pid").append('=').append(consumerPID).append(')');
            StringBuffer stringBuffer = sb.append('(').append("objectClass").append('=');
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.osgi.service.wireadmin.Consumer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            stringBuffer.append(clazz.getName()).append(')');
            sb.append(')');
            sb.append('(').append('&');
            sb.append('(').append("service.pid").append('=').append(producerPID).append(')');
            StringBuffer stringBuffer2 = sb.append('(').append("objectClass").append('=');
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.osgi.service.wireadmin.Producer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            stringBuffer2.append(clazz2.getName()).append(')');
            sb.append(')');
            if (this.consumerRef != null) {
                id = (Long)this.consumerRef.getProperty("service.id");
                sb.append('(').append("service.id").append('=').append(id).append(')');
            }
            if (this.producerRef != null) {
                id = (Long)this.producerRef.getProperty("service.id");
                sb.append('(').append("service.id").append('=').append(id).append(')');
            }
            sb.append(')');
            this.bc.addServiceListener((ServiceListener)this, ((Object)sb).toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    private ServiceReference getSingleRef(String clazz, String pid) {
        ServiceReference[] ref = null;
        try {
            ref = this.bc.getServiceReferences(clazz, "(service.pid=" + WireImpl.escapeSpecialCharacters(pid) + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (ref != null) {
            if (ref.length > 1) {
                if (Activator.LOG_DEBUG) {
                    Activator.log.debug("[WireAdmin]: Found more than one " + clazz + " services registered with the same pid: " + pid + "Wire was not created, please unregister all services which duplicate the pid.", null);
                }
                this.parent.deleteWire(this);
            } else if (ref.length == 1) {
                return ref[0];
            }
        }
        return null;
    }

    synchronized void stop() {
        if (!this.isValid) {
            return;
        }
        if (Activator.LOG_DEBUG) {
            Activator.log.debug(0, 10014, this.toString(), null, false);
        }
        this.bc.removeServiceListener((ServiceListener)this);
        if (this.producerRef != null && this.consumerRef != null) {
            this.isValid = false;
            this.informServices();
        }
        this.isValid = false;
        if (this.producerRef != null) {
            this.bc.ungetService(this.producerRef);
        }
        if (this.consumerRef != null) {
            this.bc.ungetService(this.consumerRef);
        }
        this.producerRef = null;
        this.consumerRef = null;
        this.producer = null;
        this.consumer = null;
        this.lastValue = null;
        this.previousValue = null;
        this.parent = null;
        this.filter = null;
        this.wireValues = null;
        this.scope = null;
        this.bc = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serviceRegistered(ServiceReference sRef) {
        String pid = (String)sRef.getProperty("service.pid");
        if (pid.equals(this.properties.get("wireadmin.producer.pid"))) {
            if (this.producerRef != null) return;
            this.producerRef = sRef;
            this.producer = (Producer)this.bc.getService(this.producerRef);
            if (Activator.LOG_DEBUG) {
                Activator.log.debug("[WireAdmin]: Wire " + this.properties.get("wireadmin.pid") + " detected producer " + pid, null);
            }
        } else {
            if (this.consumerRef != null) return;
            if (Activator.LOG_DEBUG) {
                Activator.log.debug("[WireAdmin]: Wire " + this.properties.get("wireadmin.pid") + " detected consumer " + pid, null);
            }
            this.consumerRef = sRef;
            this.consumer = (Consumer)this.bc.getService(this.consumerRef);
            try {
                this.flavors = (Class[])this.consumerRef.getProperty("wireadmin.consumer.flavors");
            }
            catch (ClassCastException classCastException) {}
        }
        if (this.isConnected()) {
            this.setScope();
            this.informServices();
            this.parent.notifyListeners(this, 32, null);
            this.checkInteroperability();
        } else if (!this.parent.hasAConnectedWire(pid.equals(this.properties.get("wireadmin.producer.pid")), pid) && Activator.LOG_DEBUG) {
            Activator.log.debug(0, 10015, pid, null, false);
        }
        this.updateListenerFilter();
        this.checkWireFilter();
    }

    private void checkWireFilter() {
        boolean performFiltering;
        boolean bl = performFiltering = this.producerRef != null && this.producerRef.getProperty("wireadmin.producer.filters") == null && this.properties.get("wireadmin.filter") != null;
        if (performFiltering) {
            if (this.wireValues == null) {
                this.wireValues = new Hashtable(6, 1.0f);
            }
            try {
                this.filter = this.bc.createFilter((String)this.properties.get("wireadmin.filter"));
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                if (Activator.LOG_DEBUG) {
                    Activator.log.debug("[WireAdmin]: Filter syntax is invalid, filtering won't be made", null);
                }
            }
        } else {
            this.filter = null;
        }
    }

    private void serviceModified(ServiceReference sRef) {
        String currentPID;
        String pid = (String)sRef.getProperty("service.pid");
        if (sRef.equals(this.producerRef) && !(currentPID = (String)this.properties.get("wireadmin.producer.pid")).equals(pid)) {
            this.serviceUnregistered(sRef);
            return;
        }
        if (sRef.equals(this.consumerRef)) {
            currentPID = (String)this.properties.get("wireadmin.consumer.pid");
            if (!currentPID.equals(pid)) {
                this.serviceUnregistered(sRef);
                return;
            }
            try {
                this.flavors = (Class[])this.consumerRef.getProperty("wireadmin.consumer.flavors");
            }
            catch (ClassCastException classCastException) {}
        }
        if (this.producerRef == null || this.consumerRef == null) {
            this.serviceRegistered(sRef);
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        this.setScope();
        this.checkInteroperability();
        this.checkWireFilter();
    }

    private void checkInteroperability() {
        String[] p = (String[])this.producerRef.getProperty("wireadmin.producer.composite");
        String[] c = (String[])this.consumerRef.getProperty("wireadmin.consumer.composite");
        if (p != null && c != null) {
            int i = 0;
            while (i < p.length) {
                int j = 0;
                while (j < c.length) {
                    if (p[i].equals(c[j])) {
                        this.interoperate = true;
                        return;
                    }
                    ++j;
                }
                ++i;
            }
            if (Activator.LOG_DEBUG) {
                Activator.log.debug(0, 10016, this.toString(), null, false);
            }
            this.interoperate = false;
        } else {
            this.interoperate = true;
        }
    }

    private void serviceUnregistered(ServiceReference sRef) {
        boolean lastStatus = this.isConnected();
        if (sRef.equals(this.producerRef)) {
            this.producerRef = null;
            this.producer = null;
        } else if (sRef.equals(this.consumerRef)) {
            this.consumerRef = null;
            this.consumer = null;
            this.flavors = null;
        } else {
            if (Activator.LOG_DEBUG) {
                Activator.log.debug("[WireAdmin]: Unregistering another consumer with the same pid, ignoring it ...", null);
            }
            return;
        }
        this.updateListenerFilter();
        if (lastStatus) {
            this.informServices();
            this.parent.notifyListeners(this, 64, null);
        }
        if (this.bc != null) {
            this.bc.ungetService(sRef);
        }
    }

    static String escapeSpecialCharacters(String s) {
        char[] content = s.toCharArray();
        StringBuffer result = new StringBuffer(s);
        int offset = 0;
        int i = 0;
        while (i < content.length) {
            if (content[i] == '(' || content[i] == ')' || content[i] == '*') {
                result.insert(i + offset, "\\");
                ++offset;
            }
            ++i;
        }
        return ((Object)result).toString();
    }

    void setProperties(Dictionary newProps) {
        if (newProps != null) {
            String newConsPID = (String)newProps.get("wireadmin.consumer.pid");
            String newProdPID = (String)newProps.get("wireadmin.producer.pid");
            String oldConsPID = (String)this.properties.get("wireadmin.consumer.pid");
            String oldProdPID = (String)this.properties.get("wireadmin.producer.pid");
            boolean restart = false;
            if (newConsPID == null) {
                newProps.put("wireadmin.consumer.pid", oldConsPID);
            } else if (!newConsPID.equals(oldConsPID)) {
                restart = true;
            }
            if (newProdPID == null) {
                newProps.put("wireadmin.producer.pid", oldProdPID);
            } else if (!newProdPID.equals(oldProdPID)) {
                restart = true;
            }
            if (newProps.get("wireadmin.pid") == null) {
                newProps.put("wireadmin.pid", this.properties.get("wireadmin.pid"));
            }
            this.properties.clear();
            Enumeration en = newProps.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                this.properties.put0(key, newProps.get(key));
            }
            this.checkWireFilter();
            if (restart) {
                this.stop();
                this.start();
                return;
            }
        }
        if (this.isConnected()) {
            this.informServices();
        }
        this.parent.notifyListeners(this, 8, null);
    }

    private boolean isAcceptable(Object value) {
        Class[] flavors = this.getFlavors();
        if (flavors == null) {
            return true;
        }
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].isInstance(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void serviceChanged(ServiceEvent evt) {
        if (this.bc == null) {
            return;
        }
        switch (evt.getType()) {
            case 1: {
                this.serviceRegistered(evt.getServiceReference());
                break;
            }
            case 4: {
                this.serviceUnregistered(evt.getServiceReference());
                break;
            }
            case 2: {
                this.serviceModified(evt.getServiceReference());
            }
        }
    }

    String getWirePID() {
        return (String)this.properties.get("wireadmin.pid");
    }

    private void informServices() {
        NotificationEvent ne;
        if (this.producerRef != null) {
            String producerPID = (String)this.properties.get("wireadmin.producer.pid");
            ne = new NotificationEvent(this.producer, null, this, this.parent.getConnected("wireadmin.producer.pid", producerPID));
            this.parent.notifyConsumerProducer(ne);
        }
        if (this.consumerRef != null) {
            String consumerPID = (String)this.properties.get("wireadmin.consumer.pid");
            ne = new NotificationEvent(null, this.consumer, this, this.parent.getConnected("wireadmin.consumer.pid", consumerPID));
            this.parent.notifyConsumerProducer(ne);
        }
    }
}

