/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerWriteIndication;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class UnlockObjectsIndication
extends CDOServerWriteIndication {
    private CDOSessionProtocol.UnlockObjectsResult result;

    public UnlockObjectsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)25);
    }

    protected UnlockObjectsIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readXInt();
        IRWLockManager.LockType lockType = in.readCDOLockType();
        boolean recursive = in.readBoolean();
        int size = in.readXInt();
        InternalRepository repository = this.getRepository();
        InternalView view = this.getView(viewID);
        if (size == -1) {
            this.result = repository.unlock(view, null, null, false);
        } else {
            LinkedList<CDOID> objectIDs = new LinkedList<CDOID>();
            int i = 0;
            while (i < size) {
                objectIDs.add(in.readCDOID());
                ++i;
            }
            this.result = repository.unlock(view, lockType, objectIDs, recursive);
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeXLong(this.result.getTimestamp());
        CDOLockState[] newLockStates = this.result.getNewLockStates();
        out.writeXInt(newLockStates.length);
        CDOLockState[] cDOLockStateArray = newLockStates;
        int n = newLockStates.length;
        int n2 = 0;
        while (n2 < n) {
            CDOLockState state = cDOLockStateArray[n2];
            out.writeCDOLockState(state);
            ++n2;
        }
    }
}

