/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.script.ScriptException;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.QMLAnalyzer;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLModelBuilder;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLModuleInfo;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.cdt.qt.core.IQtInstallManager;
import org.eclipse.cdt.qt.core.qmldir.QMLDirectoryInfo;
import org.eclipse.cdt.qt.core.qmljs.IQmlASTNode;

public class QMLModuleResolver {
    private final QMLAnalyzer analyzer;
    private final IQtInstallManager manager;
    private final QMLModelBuilder builder;

    public QMLModuleResolver(QMLAnalyzer analyzer) {
        this.analyzer = analyzer;
        this.manager = Activator.getService(IQtInstallManager.class);
        this.builder = new QMLModelBuilder();
    }

    public QMLModuleInfo resolveModule(String module) throws NoSuchMethodException, ScriptException {
        Path path;
        QMLModuleInfo info = this.builder.getModule(module);
        if (info == null && (path = this.getModulePath(module)) != null) {
            File qmldir = path.resolve("qmldir").normalize().toFile();
            try {
                String types = this.getQmlTypesFile(qmldir);
                File qmlTypes = path.resolve(types).toFile();
                String typeContents = this.fileToString(qmlTypes);
                IQmlASTNode ast = this.analyzer.parseString(typeContents, "qmltypes", false, false);
                info = this.builder.addModule(module, ast);
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return info;
    }

    private String fileToString(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream stream = new FileInputStream(file);){
            StringBuilder sb = new StringBuilder();
            int read = -1;
            while ((read = ((InputStream)stream).read()) != -1) {
                sb.append((char)read);
            }
            return sb.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getQmlTypesFile(File qmldir) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream stream = new FileInputStream(qmldir);){
            QMLDirectoryInfo info = new QMLDirectoryInfo(stream);
            return info.getTypesFileName();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Path getModulePath(String module) {
        if (module != null) {
            for (IQtInstall install : this.manager.getInstalls()) {
                Path qmlPath = install.getQmlPath();
                Path modPath = null;
                if (module.equals("QtQuick")) {
                    modPath = qmlPath.resolve("QtQuick.2").normalize();
                } else {
                    modPath = qmlPath;
                    String[] stringArray = module.split("\\.");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String part = stringArray[n2];
                        modPath = modPath.resolve(part).normalize();
                        ++n2;
                    }
                }
                if (!modPath.toFile().exists()) continue;
                return modPath;
            }
        }
        return null;
    }
}

