/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BorderUtil;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class LineBorder
extends BaseBorder {
    private Insets paddingInsets = new Insets();

    public Insets getInsets(IFigure figure) {
        return this.getTrueBorderInsets().add(this.paddingInsets);
    }

    @Override
    public Insets getBorderInsets() {
        return this.getTrueBorderInsets();
    }

    @Override
    public Insets getTrueBorderInsets() {
        int t = 1;
        int b = 1;
        int l = 1;
        int r = 1;
        int style = 0;
        style = this.getBorderStyle(this.bottomStyle);
        if (style != 0) {
            b = this.getBorderWidth(this.bottomWidth);
        }
        if ((style = this.getBorderStyle(this.topStyle)) != 0) {
            t = this.getBorderWidth(this.topWidth);
        }
        if ((style = this.getBorderStyle(this.leftStyle)) != 0) {
            l = this.getBorderWidth(this.leftWidth);
        }
        if ((style = this.getBorderStyle(this.rightStyle)) != 0) {
            r = this.getBorderWidth(this.rightWidth);
        }
        return new Insets(t, l, b, r);
    }

    @Override
    public void setPaddingInsets(Insets padding) {
        if (padding != null) {
            if (padding.top >= 0) {
                this.paddingInsets.top = padding.top;
            }
            if (padding.bottom >= 0) {
                this.paddingInsets.bottom = padding.bottom;
            }
            if (padding.left >= 0) {
                this.paddingInsets.left = padding.left;
            }
            if (padding.right >= 0) {
                this.paddingInsets.right = padding.right;
            }
        }
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        this.i_bottom_style = this.getBorderStyle(this.bottomStyle);
        this.i_bottom_width = this.getBorderWidth(this.bottomWidth);
        this.i_top_style = this.getBorderStyle(this.topStyle);
        this.i_top_width = this.getBorderWidth(this.topWidth);
        this.i_left_style = this.getBorderStyle(this.leftStyle);
        this.i_left_width = this.getBorderWidth(this.leftWidth);
        this.i_right_style = this.getBorderStyle(this.rightStyle);
        this.i_right_width = this.getBorderWidth(this.rightWidth);
        g.restoreState();
        this.drawBorder(figure, g, 1, this.i_bottom_style, new int[]{this.i_top_width, this.i_bottom_width, this.i_left_width, this.i_right_width}, this.bottomColor, insets);
        this.drawBorder(figure, g, 0, this.i_top_style, new int[]{this.i_top_width, this.i_bottom_width, this.i_left_width, this.i_right_width}, this.topColor, insets);
        this.drawBorder(figure, g, 2, this.i_left_style, new int[]{this.i_top_width, this.i_bottom_width, this.i_left_width, this.i_right_width}, this.leftColor, insets);
        this.drawBorder(figure, g, 3, this.i_right_style, new int[]{this.i_top_width, this.i_bottom_width, this.i_left_width, this.i_right_width}, this.rightColor, insets);
    }

    protected void drawBorder(IFigure figure, Graphics g, int side, int style, int[] width, int color, Insets insets) {
        Rectangle r = figure.getBounds().getCopy().crop(insets);
        if (style != 0) {
            g.setForegroundColor(ColorManager.getColor((int)color));
            BorderUtil.drawBorderLine(g, side, style, width, r);
        } else {
            g.setForegroundColor(ReportColorConstants.ShadowLineColor);
            BorderUtil.drawDefaultLine(g, side, r);
        }
        g.restoreState();
    }

    public Insets getPaddingInsets() {
        return new Insets(this.paddingInsets);
    }
}

