/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.dom.IDOMRefPosition;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRefPosition
implements IDOMRefPosition {
    Node _refNode;
    boolean _forward;

    public DOMRefPosition(Node refNode, boolean forward) {
        this._refNode = refNode;
        this._forward = forward;
    }

    public Node getSibling(boolean forward) {
        if (forward != this._forward) {
            return this._refNode;
        }
        if (forward) {
            return this._refNode.getNextSibling();
        }
        return this._refNode.getPreviousSibling();
    }

    public Node getNextSiblingNode() {
        return this.getSibling(true);
    }

    public Node getPreviousSiblingNode() {
        return this.getSibling(false);
    }

    public Node getContainerNode() {
        return this._refNode.getParentNode();
    }

    public int getOffset() {
        Node parent = this._refNode.getParentNode();
        if (parent == null) {
            return this._forward ? 1 : 0;
        }
        NodeList list = parent.getChildNodes();
        int i = 0;
        int n = list.getLength();
        while (i < n) {
            if (list.item(i) == this._refNode) {
                return this._forward ? i + 1 : i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isText() {
        return false;
    }

    public IDOMPosition handleReplacement(Node original, Node replacement) {
        if (this._refNode == original) {
            return new DOMRefPosition(replacement, this._forward);
        }
        return this;
    }

    public String toString() {
        return "DOMRefPosition: (" + (this._forward ? "after " : "before ") + this._refNode + ")";
    }

    public Node getReferenceNode() {
        return this._refNode;
    }

    public boolean isForward() {
        return this._forward;
    }
}

