/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.model.Activator;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

final class LogDetailed {
    private LogDetailed() {
    }

    public static boolean execute(ESLocalProject localProject, ESPrimaryVersionSpec versionSpec, IProgressMonitor monitor, boolean shouldFail) throws ESException {
        WorkspaceUtil.logWarning("Checksum comparison failed.", null);
        Project project = ((ProjectSpace)((ESLocalProjectImpl)ESLocalProjectImpl.class.cast(localProject)).toInternalAPI()).getProject();
        ESLocalProject serverESProject = localProject.getRemoteProject().checkout("log_error_checksum_debug_checkout", localProject.getUsersession(), versionSpec, (IProgressMonitor)new NullProgressMonitor());
        Project serverProject = ((ProjectSpace)((ESLocalProjectImpl)ESLocalProjectImpl.class.cast(serverESProject)).toInternalAPI()).getProject();
        try {
            LinkedHashMap<String, Boolean> formatOptions = new LinkedHashMap<String, Boolean>();
            formatOptions.put("DECLARE_XML", Boolean.TRUE);
            formatOptions.put("FORMATTED", Boolean.TRUE);
            String localSerialization = ModelUtil.eObjectToString((EObject)project, (Map)ModelUtil.getResourceSaveOptions());
            String serverSerialization = ModelUtil.eObjectToString((EObject)serverProject, (Map)ModelUtil.getResourceSaveOptions());
            serverESProject.delete((IProgressMonitor)new NullProgressMonitor());
            File localFile = Activator.getDefault().getBundle().getDataFile("localProjectSerialization.txt");
            File serverFile = Activator.getDefault().getBundle().getDataFile("serverProjectSerialization.txt");
            FileWriter fileWriterLocal = new FileWriter(localFile);
            fileWriterLocal.write(localSerialization);
            fileWriterLocal.close();
            FileWriter fileWriterServer = new FileWriter(serverFile);
            fileWriterServer.write(serverSerialization);
            fileWriterServer.close();
        }
        catch (SerializationException ex) {
            WorkspaceUtil.logException("Couldn't log the serializations.", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            WorkspaceUtil.logException("Couldn't save the serializations.", ex);
        }
        return !shouldFail;
    }
}

