/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.downloads;

import java.util.Collection;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.ui.internal.FormTextHoverManager;
import org.eclipse.cdt.arduino.ui.internal.LibraryTree;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SelectLibrariesDialog
extends Dialog {
    private Collection<ArduinoLibrary> libraries;
    private Collection<ArduinoLibrary> checkedLibraries;
    private LibraryTree libraryTree;

    public SelectLibrariesDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        if (size.x < 600 || size.y < 400) {
            return new Point(600, 400);
        }
        return size;
    }

    public void setLibraries(Collection<ArduinoLibrary> libraries) {
        this.libraries = libraries;
    }

    public Collection<ArduinoLibrary> getChecked() {
        return this.checkedLibraries;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setLayout((Layout)new GridLayout());
        this.libraryTree = new LibraryTree(comp);
        this.libraryTree.setLayoutData(new GridData(1808));
        this.libraryTree.setIncludePlatforms(false);
        this.libraryTree.getViewer().setInput(this.libraries);
        FormTextHoverManager hoverManager = new FormTextHoverManager(){

            protected void computeInformation() {
                TreeViewer viewer = SelectLibrariesDialog.this.libraryTree.getViewer();
                Tree tree = viewer.getTree();
                TreeItem item = tree.getItem(this.getHoverEventLocation());
                if (item != null) {
                    Object data = item.getData();
                    if (data instanceof ArduinoLibrary) {
                        ArduinoLibrary library = (ArduinoLibrary)data;
                        this.setInformation(library.toFormText(), item.getBounds());
                    }
                } else {
                    this.setInformation(null, null);
                }
            }
        };
        hoverManager.install((Control)this.libraryTree.getViewer().getTree());
        SelectLibrariesDialog.applyDialogFont((Control)comp);
        return comp;
    }

    protected void okPressed() {
        this.checkedLibraries = this.libraryTree.getChecked();
        super.okPressed();
    }
}

