/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public final class TranslationTable
implements Cloneable {
    Map<String, List<Translation>> resourceMap = new LinkedHashMap<String, List<Translation>>();

    public void add(Translation newTranslation) {
        assert (newTranslation != null);
        String resourceKey = newTranslation.getResourceKey();
        List<Translation> translationList = this.resourceMap.get(resourceKey);
        if (translationList == null) {
            translationList = new ArrayList<Translation>();
            this.resourceMap.put(resourceKey, translationList);
        }
        translationList.add(newTranslation);
    }

    public boolean remove(Translation trans) {
        if (trans == null) {
            return false;
        }
        List<Translation> translationList = this.resourceMap.get(trans.getResourceKey());
        if (translationList == null) {
            return false;
        }
        return translationList.remove(trans);
    }

    public String getMessage(String resourceKey) {
        return this.getMessage(resourceKey, ThreadResources.getLocale());
    }

    public String getMessage(String resourceKey, ULocale theLocale) {
        String language;
        Translation trans;
        String locale;
        if (StringUtil.isBlank(resourceKey)) {
            return null;
        }
        String string = locale = theLocale == null ? null : theLocale.toString();
        if (locale == null) {
            Translation trans2 = this.findTranslation(resourceKey, null);
            return trans2 != null ? trans2.getText() : null;
        }
        List<Translation> translationList = this.resourceMap.get(resourceKey);
        if (translationList == null) {
            return null;
        }
        if (locale.length() > 5) {
            locale = locale.substring(0, 5);
        }
        if ((trans = this.findTranslation(resourceKey, locale)) != null) {
            return trans.getText();
        }
        if (locale != null && locale.length() >= 2 && (trans = this.findTranslation(resourceKey, language = locale.substring(0, 2))) != null) {
            return trans.getText();
        }
        trans = this.findTranslation(resourceKey, null);
        if (trans != null) {
            return trans.getText();
        }
        return null;
    }

    public Translation findTranslation(String resourceKey, String locale) {
        List<Translation> translationList = this.resourceMap.get(resourceKey);
        if (translationList == null) {
            return null;
        }
        for (Translation trans : translationList) {
            if (locale == null && trans.getLocale() == null) {
                return trans;
            }
            if (locale == null || !locale.equalsIgnoreCase(trans.getLocale())) continue;
            return trans;
        }
        return null;
    }

    public boolean contains(Translation trans) {
        if (trans == null) {
            return false;
        }
        return this.findTranslation(trans.getResourceKey(), trans.getLocale()) != null;
    }

    public List<Translation> getTranslations() {
        ArrayList<Translation> translations = new ArrayList<Translation>();
        Iterator<List<Translation>> iterator = this.resourceMap.values().iterator();
        while (iterator.hasNext()) {
            translations.addAll((Collection<Translation>)iterator.next());
        }
        if (translations.isEmpty()) {
            return null;
        }
        return translations;
    }

    public List<Translation> getTranslations(String resourceKey) {
        return this.resourceMap.get(resourceKey);
    }

    public String[] getResourceKeys() {
        Set<String> keySet = this.resourceMap.keySet();
        int size = keySet.size();
        if (size == 0) {
            return null;
        }
        String[] keys = new String[size];
        keySet.toArray(keys);
        return keys;
    }

    public Object clone() throws CloneNotSupportedException {
        TranslationTable table = (TranslationTable)super.clone();
        table.resourceMap = new LinkedHashMap<String, List<Translation>>();
        for (List<Translation> transList : this.resourceMap.values()) {
            int i = 0;
            while (i < transList.size()) {
                Translation trans = transList.get(i);
                table.add((Translation)trans.clone());
                ++i;
            }
        }
        return table;
    }
}

