/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import org.eclipse.jface.text.ITextStore;

public class SubSetTextStore
implements ITextStore {
    private int pseudoBeginOffset;
    private int pseudoLength;
    private StringBuffer stringBuffer = new StringBuffer();

    public SubSetTextStore(String initialContent, int beginOffset, int endOffset, int originalDocumentLength) {
        this.pseudoBeginOffset = beginOffset;
        this.pseudoLength = originalDocumentLength;
        this.stringBuffer = new StringBuffer(initialContent);
    }

    private String _get(int begin, int length) {
        char[] chars = new char[length];
        int srcEnd = begin + length;
        this.stringBuffer.getChars(begin, srcEnd, chars, 0);
        return new String(chars);
    }

    public char get(int offset) {
        return this.stringBuffer.charAt(offset - this.pseudoBeginOffset);
    }

    public String get(int begin, int length) {
        return this._get(begin - this.pseudoBeginOffset, length);
    }

    public char getChar(int pos) {
        return this.get(pos - this.pseudoBeginOffset);
    }

    public int getLength() {
        return this.pseudoLength;
    }

    public int getTrueLength() {
        return this.stringBuffer.length();
    }

    public void replace(int begin, int length, String changes) {
        int end = begin + length;
        this.stringBuffer.replace(begin - this.pseudoBeginOffset, end, changes);
    }

    public void set(String text) {
        this.stringBuffer.setLength(0);
        this.stringBuffer.append(text);
    }
}

