/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.ui.actions.FortranEditorASTActionDelegate;
import org.eclipse.photran.internal.ui.actions.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class SelectEnclosingScope
extends FortranEditorASTActionDelegate {
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                progressMonitor.beginTask(Messages.SelectEnclosingScope_WaitingForBackgroundWorkToComplete, -1);
                progressMonitor.subTask(Messages.SelectEnclosingScope_Parsing);
                Token token = this.findEnclosingToken(this.getAST(), this.getFortranEditor().getSelection());
                if (token == null) {
                    throw new Exception(Messages.SelectEnclosingScope_PleaseSelectAKeywordOrIdentifier);
                }
                ScopingNode scope = token.getEnclosingScope();
                if (scope == null) {
                    throw new Exception(Messages.SelectEnclosingScope_NoEnclosingScope);
                }
                IMarker marker = scope.createMarker();
                if (marker == null) {
                    throw new Exception(Messages.SelectEnclosingScope_NoTokensInScope);
                }
                IDE.openEditor((IWorkbenchPage)this.getFortranEditor().getEditorSite().getPage(), (IMarker)marker, (boolean)true);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)Messages.SelectEnclosingScope_ErrorTitle, (String)message);
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

