/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.cs2as;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.PrecedenceManager;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedValue;
import org.eclipse.ocl.xtext.base.cs2as.BaseCSPreOrderVisitor;
import org.eclipse.ocl.xtext.base.cs2as.BasicContinuation;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.cs2as.CS2ASConversion;
import org.eclipse.ocl.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.xtext.base.cs2as.Dependency;
import org.eclipse.ocl.xtext.base.cs2as.SingleContinuation;
import org.eclipse.ocl.xtext.basecs.ContextLessElementCS;
import org.eclipse.ocl.xtext.basecs.MultiplicityCS;
import org.eclipse.ocl.xtext.basecs.NamedElementCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.basecs.TypedTypeRefCS;
import org.eclipse.ocl.xtext.essentialocl.attributes.NavigationUtil;
import org.eclipse.ocl.xtext.essentialoclcs.CollectionTypeCS;
import org.eclipse.ocl.xtext.essentialoclcs.ContextCS;
import org.eclipse.ocl.xtext.essentialoclcs.ExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.MapTypeCS;
import org.eclipse.ocl.xtext.essentialoclcs.NameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.xtext.essentialoclcs.PrefixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.TypeNameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.VariableCS;
import org.eclipse.ocl.xtext.essentialoclcs.util.AbstractEssentialOCLCSPreOrderVisitor;

public class EssentialOCLCSPreOrderVisitor
extends AbstractEssentialOCLCSPreOrderVisitor {
    protected static boolean isReady(TypedRefCS csTypedRef) {
        Element unspecializedPivotElement;
        if (csTypedRef == null) {
            return true;
        }
        if (csTypedRef instanceof TypedTypeRefCS && (unspecializedPivotElement = CS2AS.basicGetType((TypedTypeRefCS)((TypedTypeRefCS)csTypedRef))) == null) {
            return false;
        }
        return csTypedRef.getPivot() != null;
    }

    public EssentialOCLCSPreOrderVisitor(@NonNull CS2ASConversion context) {
        super(context);
    }

    @Override
    public Continuation<?> visitCollectionTypeCS(@NonNull CollectionTypeCS csCollectionType) {
        return new CollectionTypeContinuation((CS2ASConversion)this.context, csCollectionType);
    }

    @Override
    public Continuation<?> visitContextCS(@NonNull ContextCS csContext) {
        return null;
    }

    public Continuation<?> visitContextLessElementCS(@NonNull ContextLessElementCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitExpCS(@NonNull ExpCS csExp) {
        return null;
    }

    @Override
    public Continuation<?> visitInfixExpCS(@NonNull InfixExpCS csElement) {
        if (NavigationUtil.isNavigationInfixExp((EObject)csElement)) {
            csElement.setPrecedence(PrecedenceManager.NAVIGATION_PRECEDENCE, PrecedenceManager.NAVIGATION_PRECEDENCE_ORDER);
            return null;
        }
        return new InfixExpContinuation((CS2ASConversion)this.context, csElement);
    }

    @Override
    public Continuation<?> visitMapTypeCS(@NonNull MapTypeCS csMapType) {
        return new MapTypeContinuation((CS2ASConversion)this.context, csMapType);
    }

    @Override
    public Continuation<?> visitNameExpCS(@NonNull NameExpCS csNameExp) {
        return null;
    }

    @Override
    public Continuation<?> visitNavigatingArgCS(@NonNull NavigatingArgCS csNavigatingArg) {
        return null;
    }

    @Override
    public Continuation<?> visitPrefixExpCS(@NonNull PrefixExpCS csElement) {
        return new PrefixExpContinuation((CS2ASConversion)this.context, csElement);
    }

    @Override
    public Continuation<?> visitTypeNameExpCS(@NonNull TypeNameExpCS csTypeNameExp) {
        return new TypeNameExpContinuation((CS2ASConversion)this.context, csTypeNameExp);
    }

    @Override
    public Continuation<?> visitVariableCS(@NonNull VariableCS csVariable) {
        return null;
    }

    protected static class CollectionTypeContinuation
    extends SingleContinuation<CollectionTypeCS> {
        public CollectionTypeContinuation(@NonNull CS2ASConversion context, @NonNull CollectionTypeCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            return EssentialOCLCSPreOrderVisitor.isReady(((CollectionTypeCS)this.csElement).getOwnedType());
        }

        public BasicContinuation<?> execute() {
            Type elementType;
            PivotMetamodelManager metamodelManager = this.context.getMetamodelManager();
            TypedRefCS csElementType = ((CollectionTypeCS)this.csElement).getOwnedType();
            Class type = null;
            String name = ((CollectionTypeCS)this.csElement).getName();
            assert (name != null);
            if (csElementType != null && (elementType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csElementType)) != null) {
                UnlimitedValue upperValue;
                IntegerValue lowerValue;
                boolean isNullFree;
                MultiplicityCS csMultiplicity = ((CollectionTypeCS)this.csElement).getOwnedCollectionMultiplicity();
                if (csMultiplicity != null) {
                    isNullFree = csMultiplicity.isIsNullFree();
                    lowerValue = ValueUtil.integerValueOf((int)csMultiplicity.getLower());
                    int upper = csMultiplicity.getUpper();
                    upperValue = upper != -1 ? ValueUtil.unlimitedNaturalValueOf((int)upper) : ValueUtil.UNLIMITED_VALUE;
                } else {
                    isNullFree = true;
                    lowerValue = null;
                    upperValue = null;
                }
                type = metamodelManager.getCollectionType(name, elementType, isNullFree, lowerValue, upperValue);
            }
            if (type == null) {
                type = metamodelManager.getStandardLibrary().getLibraryType(name);
            }
            ((CollectionTypeCS)this.csElement).setPivot((Element)type);
            return null;
        }
    }

    protected static class InfixExpContinuation
    extends BaseCSPreOrderVisitor.OperatorExpContinuation<InfixExpCS> {
        public InfixExpContinuation(@NonNull CS2ASConversion context, @NonNull InfixExpCS csElement) {
            super(context, (NamedElementCS)csElement);
        }

        public BasicContinuation<?> execute() {
            Precedence precedence;
            PivotMetamodelManager metamodelManager = this.context.getMetamodelManager();
            String operatorName = ((InfixExpCS)this.csElement).getName();
            Precedence precedence2 = precedence = operatorName != null ? metamodelManager.getPrecedenceManager().getInfixPrecedence(operatorName) : null;
            if (precedence != null) {
                ((InfixExpCS)this.csElement).setPrecedence(precedence, metamodelManager.getPrecedenceManager().getOrder(precedence));
            } else {
                ((InfixExpCS)this.csElement).setPrecedence(null, 0x3FFFFFFF);
            }
            return super.execute();
        }
    }

    protected static class MapTypeContinuation
    extends SingleContinuation<MapTypeCS> {
        public MapTypeContinuation(@NonNull CS2ASConversion context, @NonNull MapTypeCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public boolean canExecute() {
            if (!super.canExecute()) {
                return false;
            }
            return EssentialOCLCSPreOrderVisitor.isReady(((MapTypeCS)this.csElement).getOwnedKeyType()) && EssentialOCLCSPreOrderVisitor.isReady(((MapTypeCS)this.csElement).getOwnedValueType());
        }

        public BasicContinuation<?> execute() {
            PivotMetamodelManager metamodelManager = this.context.getMetamodelManager();
            TypedRefCS csKeyType = ((MapTypeCS)this.csElement).getOwnedKeyType();
            TypedRefCS csValueType = ((MapTypeCS)this.csElement).getOwnedValueType();
            Class type = null;
            String name = ((MapTypeCS)this.csElement).getName();
            assert (name != null);
            if (csKeyType != null && csValueType != null) {
                Boolean keysAreNullFree = this.context.isRequired(csKeyType);
                Boolean valuesAreNullFree = this.context.isRequired(csValueType);
                Type keyType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csKeyType);
                Type valueType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csValueType);
                if (keyType != null && valueType != null) {
                    type = metamodelManager.getMapType(name, keyType, keysAreNullFree != Boolean.FALSE, valueType, valuesAreNullFree != Boolean.FALSE);
                }
            }
            if (type == null) {
                type = metamodelManager.getStandardLibrary().getLibraryType(name);
            }
            this.context.installPivotTypeWithMultiplicity((Type)type, (TypedRefCS)this.csElement);
            return null;
        }
    }

    protected static class PrefixExpContinuation
    extends BaseCSPreOrderVisitor.OperatorExpContinuation<PrefixExpCS> {
        public PrefixExpContinuation(@NonNull CS2ASConversion context, @NonNull PrefixExpCS csElement) {
            super(context, (NamedElementCS)csElement);
        }

        public BasicContinuation<?> execute() {
            Precedence precedence;
            PivotMetamodelManager metamodelManager = this.context.getMetamodelManager();
            String operatorName = ((PrefixExpCS)this.csElement).getName();
            Precedence precedence2 = precedence = operatorName != null ? metamodelManager.getPrecedenceManager().getPrefixPrecedence(operatorName) : null;
            if (precedence != null) {
                ((PrefixExpCS)this.csElement).setPrecedence(precedence, metamodelManager.getPrecedenceManager().getOrder(precedence));
            } else {
                ((PrefixExpCS)this.csElement).setPrecedence(null, 0x3FFFFFFF);
            }
            return super.execute();
        }
    }

    protected static class TypeNameExpContinuation
    extends SingleContinuation<TypeNameExpCS> {
        public TypeNameExpContinuation(@NonNull CS2ASConversion context, @NonNull TypeNameExpCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[]{context.getOperatorsHavePrecedenceInterDependency()});
        }

        public BasicContinuation<?> execute() {
            Type element = ((TypeNameExpCS)this.csElement).getElement();
            this.context.installPivotTypeWithMultiplicity(element, (TypedRefCS)this.csElement);
            return null;
        }
    }
}

