/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jst.pagedesigner.commands.range.IInputSourceProvider;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KeyboardData
implements IInputSourceProvider {
    private Character _keyCode;
    private int _stateMask;
    private GraphicalViewer _viewer;

    public KeyboardData(char code, int mask, GraphicalViewer viewer) {
        this._keyCode = (mask & 0x20000) != 0 ? new Character(Character.toUpperCase(code)) : new Character(code);
        this._stateMask = mask;
        this._viewer = viewer;
    }

    public int getKeyCode() {
        return this._keyCode.charValue();
    }

    public void setKeyCode(char keyCode) {
        this._keyCode = new Character(keyCode);
    }

    public int getStateMask() {
        return this._stateMask;
    }

    public void setStateMask(int stateMask) {
        this._stateMask = stateMask;
    }

    public Node getSpecialNode(KeyboardData keyCode) {
        Object name;
        EditDomain domain = this._viewer.getEditDomain();
        Document document = null;
        if (domain instanceof DefaultEditDomain) {
            document = ((HTMLEditor)((DefaultEditDomain)domain).getEditorPart()).getDOMDocument();
        }
        if ((name = EditModelQuery.CHAR_NODE_MAP.get(keyCode.getCharacterData())) != null) {
            return document.createElement((String)name);
        }
        return null;
    }

    public Node[] getNodes() {
        Node node = this.getSpecialNode(this);
        if (node != null) {
            return new Node[]{node};
        }
        return null;
    }

    public String getStringData() {
        return this._keyCode.toString();
    }

    public Character getCharacterData() {
        return this._keyCode;
    }

    public char getChar() {
        return this._keyCode.charValue();
    }
}

