/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class RepositoryCache {
    private final Map<File, Reference<Repository>> repositoryCache = new HashMap<File, Reference<Repository>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository lookupRepository(File gitDir) throws IOException {
        File normalizedGitDir = new Path(gitDir.getAbsolutePath()).toFile();
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            Reference<Repository> r = this.repositoryCache.get(normalizedGitDir);
            if (r == null) {
                Repository result = FileRepositoryBuilder.create((File)normalizedGitDir);
                this.repositoryCache.put(normalizedGitDir, new WeakReference<Repository>(result));
                return result;
            }
            Repository result = r.get();
            if (result != null && result.getDirectory().exists()) {
                return result;
            }
            this.repositoryCache.remove(normalizedGitDir);
        }
        IndexDiffCache cache = Activator.getDefault().getIndexDiffCache();
        if (cache != null) {
            cache.remove(normalizedGitDir);
        }
        return this.lookupRepository(gitDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(File gitDir) {
        if (gitDir == null) {
            return null;
        }
        File normalizedGitDir = new Path(gitDir.getAbsolutePath()).toFile();
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            Reference<Repository> r;
            block7: {
                r = this.repositoryCache.get(normalizedGitDir);
                if (r != null) break block7;
                return null;
            }
            Repository result = r.get();
            if (result != null && result.getDirectory().exists()) {
                return result;
            }
            this.repositoryCache.remove(normalizedGitDir);
        }
        IndexDiffCache cache = Activator.getDefault().getIndexDiffCache();
        if (cache != null) {
            cache.remove(normalizedGitDir);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository[] getAllRepositories() {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        ArrayList<File> toRemove = new ArrayList<File>();
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            Iterator<Map.Entry<File, Reference<Repository>>> i = this.repositoryCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<File, Reference<Repository>> entry = i.next();
                Repository repository = entry.getValue().get();
                if (repository == null || !repository.getDirectory().exists()) {
                    i.remove();
                    toRemove.add(entry.getKey());
                    continue;
                }
                repositories.add(repository);
            }
        }
        this.removeIndexDiffCaches(toRemove);
        return repositories.toArray(new Repository[0]);
    }

    public Repository getRepository(IResource resource) {
        IPath location = resource.getLocation();
        return location == null ? null : this.getRepository(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(IPath location) {
        if (location == null) {
            return null;
        }
        Repository repository = null;
        int largestSegmentCount = 0;
        ArrayList<File> toRemove = new ArrayList<File>();
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            Iterator<Map.Entry<File, Reference<Repository>>> i = this.repositoryCache.entrySet().iterator();
            while (i.hasNext()) {
                Path repoPath;
                Map.Entry<File, Reference<Repository>> entry = i.next();
                Repository repo = entry.getValue().get();
                if (repo == null) {
                    i.remove();
                    toRemove.add(entry.getKey());
                    continue;
                }
                if (repo.isBare() || !(repoPath = new Path(repo.getWorkTree().getAbsolutePath())).isPrefixOf(location) || repository != null && repoPath.segmentCount() <= largestSegmentCount) continue;
                if (!repo.getDirectory().exists()) {
                    i.remove();
                    toRemove.add(entry.getKey());
                    continue;
                }
                repository = repo;
                largestSegmentCount = repoPath.segmentCount();
            }
        }
        this.removeIndexDiffCaches(toRemove);
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<File> gitDirs;
        Map<File, Reference<Repository>> map = this.repositoryCache;
        synchronized (map) {
            gitDirs = new ArrayList<File>(this.repositoryCache.keySet());
            this.repositoryCache.clear();
        }
        this.removeIndexDiffCaches(gitDirs);
    }

    private void removeIndexDiffCaches(List<File> gitDirs) {
        IndexDiffCache cache;
        if (!gitDirs.isEmpty() && (cache = Activator.getDefault().getIndexDiffCache()) != null) {
            for (File f : gitDirs) {
                cache.remove(f);
            }
        }
    }
}

