/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormProvider;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.GroupHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractFormHandleProvider
extends AbstractDescriptorProvider
implements IFormProvider {
    protected static Logger logger = Logger.getLogger(AbstractFormHandleProvider.class.getName());
    protected Object input;
    private boolean isReadOnly = true;

    @Override
    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    @Override
    public boolean isEnable() {
        if (this.isReadOnly) {
            return false;
        }
        return DEUtil.getInputSize((Object)this.input) == 1;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public boolean edit(int pos) {
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        if (!this.doEditItem(pos)) {
            stack.rollback();
            return false;
        }
        stack.commit();
        return true;
    }

    public void add(int pos) throws Exception {
        boolean sucess = false;
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        try {
            sucess = this.doAddItem(pos);
        }
        catch (Exception e) {
            stack.rollback();
            throw new Exception(e);
        }
        if (sucess) {
            stack.commit();
        } else {
            stack.rollback();
        }
    }

    public void transModify(Object data, String property, Object value) throws Exception {
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        try {
            this.modify(data, property, value);
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            throw new Exception(e);
        }
    }

    protected CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    public FormContentProvider getFormContentProvider(IModelEventProcessor listener, IDescriptorProvider provider) {
        return new FormContentProvider(listener, provider);
    }

    @Override
    public Object load() {
        return null;
    }

    @Override
    public void save(Object value) throws SemanticException {
    }

    @Override
    public boolean isAddEnable(Object selectedObject) {
        return true;
    }

    @Override
    public boolean isEditEnable(Object selectedObject) {
        return true;
    }

    @Override
    public boolean isDeleteEnable(Object selectedObject) {
        return true;
    }

    @Override
    public boolean isUpEnable(Object selectedObject) {
        return true;
    }

    @Override
    public boolean isDownEnable(Object selectedObject) {
        return true;
    }

    @Override
    public boolean needRebuilded(NotificationEvent event) {
        return false;
    }

    @Override
    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        return false;
    }

    @Override
    public Image getImage(Object element, int columnIndex) {
        return null;
    }

    @Override
    public boolean modify(Object data, String property, Object value) throws Exception {
        return false;
    }

    @Override
    public boolean needRefreshed(NotificationEvent event) {
        return false;
    }

    @Override
    public boolean canModify(Object element, String property) {
        return false;
    }

    public class FormContentProvider
    implements IStructuredContentProvider {
        private IModelEventProcessor listener;
        private IDescriptorProvider provider;

        public FormContentProvider(IModelEventProcessor listener, IDescriptorProvider provider) {
            this.listener = listener;
            this.provider = provider;
        }

        public Object[] getElements(Object inputElement) {
            assert (this.provider instanceof AbstractFormHandleProvider);
            Object[] elements = ((AbstractFormHandleProvider)this.provider).getElements(inputElement);
            this.registerEventManager();
            this.deRegisterEventManager();
            return elements;
        }

        public void dispose() {
            if (!((IFormProvider)this.provider instanceof GroupHandleProvider)) {
                return;
            }
            Object[] elements = ((IFormProvider)this.provider).getElements(AbstractFormHandleProvider.this.input);
            if (elements == null) {
                return;
            }
            this.deRegisterEventManager();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        protected void deRegisterEventManager() {
            if (UIUtil.getModelEventManager() != null) {
                UIUtil.getModelEventManager().removeModelEventProcessor(this.listener);
            }
        }

        protected void registerEventManager() {
            if (UIUtil.getModelEventManager() != null) {
                UIUtil.getModelEventManager().addModelEventProcessor(this.listener);
            }
        }
    }
}

