/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import java.io.File;
import java.lang.reflect.Field;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.testing.AbstractWorkbenchTest;

public abstract class AbstractEditorTest
extends AbstractWorkbenchTest {
    static final long STEP_DELAY = 0L;

    protected abstract String getEditorId();

    protected XtextEditor openEditor(IFile file) throws Exception {
        return this.getXtextEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), this.getEditorId()));
    }

    protected XtextEditor openEditorForExternalFile(File file) throws Exception {
        IFileStore store = EFS.getLocalFileSystem().getStore(file.toURI());
        return this.getXtextEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileStoreEditorInput(store), this.getEditorId()));
    }

    private XtextEditor getXtextEditor(IEditorPart openEditor) throws NoSuchFieldException, IllegalAccessException {
        XtextEditor xtextEditor = EditorUtils.getXtextEditor((IEditorPart)openEditor);
        if (xtextEditor != null) {
            ISourceViewer sourceViewer = xtextEditor.getInternalSourceViewer();
            ((ProjectionViewer)sourceViewer).doOperation(20);
            return xtextEditor;
        }
        if (openEditor instanceof ErrorEditorPart) {
            Field field = openEditor.getClass().getDeclaredField("error");
            field.setAccessible(true);
            throw new IllegalStateException("Couldn't open the editor.", ((Status)field.get(openEditor)).getException());
        }
        AbstractEditorTest.fail((String)("Opened Editor with id:" + this.getEditorId() + ", is not an XtextEditor"));
        return null;
    }
}

