/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.graphical;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.draw2d.EventManager;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.gef.core.EditDomain;

public class EditEventManager
extends EventManager
implements KeyListener {
    private final EditDomain m_domain;
    private final IEditPartViewer m_viewer;
    private boolean m_eventCapture;
    private Cursor m_overrideCursor;
    private MouseEvent m_currentMouseEvent;

    public EditEventManager(FigureCanvas canvas, EditDomain domain, IEditPartViewer viewer) {
        super(canvas);
        this.m_domain = domain;
        this.m_viewer = viewer;
        Object listener = EditEventManager.createListenerProxy(this, new Class[]{KeyListener.class});
        canvas.addKeyListener((KeyListener)listener);
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.m_overrideCursor == null) {
            super.setCursor(cursor);
        } else {
            super.setCursor(this.m_overrideCursor);
        }
    }

    public void setOverrideCursor(Cursor cursor) {
        if (this.m_overrideCursor != cursor) {
            this.m_overrideCursor = cursor;
            if (this.m_overrideCursor == null) {
                if (this.m_eventCapture) {
                    super.setCursor(null);
                } else {
                    this.updateFigureUnderCursor(this.m_currentMouseEvent);
                    this.updateCursor();
                }
            } else {
                this.setCursor(this.m_overrideCursor);
            }
        }
    }

    public void keyPressed(KeyEvent event) {
        this.m_domain.keyPressed(event, this.m_viewer);
    }

    public void keyReleased(KeyEvent event) {
        this.m_domain.keyReleased(event, this.m_viewer);
    }

    @Override
    public void mouseDoubleClick(MouseEvent event) {
        this.m_currentMouseEvent = event;
        if (!this.m_eventCapture) {
            super.mouseDoubleClick(event);
            if (this.isEventConsumed()) {
                return;
            }
        }
        this.m_domain.mouseDoubleClick(event, this.m_viewer);
    }

    @Override
    public void mouseDown(MouseEvent event) {
        this.m_viewer.getControl().forceFocus();
        this.m_currentMouseEvent = event;
        if (!this.m_eventCapture) {
            super.mouseDown(event);
            if (this.isEventConsumed()) {
                return;
            }
        }
        this.m_eventCapture = true;
        this.m_domain.mouseDown(event, this.m_viewer);
    }

    @Override
    public void mouseUp(MouseEvent event) {
        this.m_currentMouseEvent = event;
        if (!this.m_eventCapture) {
            super.mouseUp(event);
            if (this.isEventConsumed()) {
                return;
            }
        }
        boolean eventCapture = this.m_eventCapture;
        this.m_eventCapture = false;
        this.m_domain.mouseUp(event, this.m_viewer);
        if (eventCapture) {
            this.updateFigureUnderCursor(event);
        }
    }

    @Override
    public void mouseMove(MouseEvent event) {
        this.m_currentMouseEvent = event;
        if (!this.m_eventCapture) {
            super.mouseMove(event);
            if (this.isEventConsumed()) {
                return;
            }
        }
        if ((event.stateMask & 0x380000) != 0) {
            this.m_domain.mouseDrag(event, this.m_viewer);
        } else {
            this.m_domain.mouseMove(event, this.m_viewer);
        }
    }

    @Override
    public void mouseEnter(MouseEvent event) {
        this.m_currentMouseEvent = event;
        this.m_domain.viewerEntered(event, this.m_viewer);
        this.updateFigureUnderCursor(event);
    }

    @Override
    public void mouseExit(MouseEvent event) {
        this.m_eventCapture = false;
        this.m_currentMouseEvent = event;
        this.m_domain.viewerExited(event, this.m_viewer);
        this.updateFigureUnderCursor(event);
    }

    @Override
    public void mouseHover(MouseEvent event) {
    }
}

