/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher;

import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public class MatcherReference {
    final PQuery query;
    final Set<PParameter> adornment;
    final QueryEvaluationHint hints;

    public MatcherReference(PQuery query, Set<PParameter> adornment, QueryEvaluationHint hints) {
        this.query = query;
        this.adornment = adornment;
        this.hints = hints;
    }

    public MatcherReference(PQuery query, Set<PParameter> adornment) {
        this(query, adornment, null);
    }

    public PQuery getQuery() {
        return this.query;
    }

    public Set<PParameter> getAdornment() {
        return this.adornment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adornment == null ? 0 : this.adornment.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatcherReference other = (MatcherReference)obj;
        if (this.adornment == null ? other.adornment != null : !this.adornment.equals(other.adornment)) {
            return false;
        }
        return !(this.query == null ? other.query != null : !this.query.equals(other.query));
    }

    public QueryEvaluationHint getHints() {
        return this.hints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.query.getFullyQualifiedName());
        sb.append("(");
        for (PParameter p : this.query.getParameters()) {
            sb.append(this.adornment.contains(p) ? "b" : "f");
        }
        sb.append(")");
        return sb.toString();
    }
}

