/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.dataviewers.piechart.PieChart;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.IPieChartViewerState;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.PieChartViewerStateNoContentSelected;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.model.TmfPieChartStatisticsModel;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;

public class TmfPieChartViewer
extends Composite {
    private PieChart fGlobalPC;
    private String fGlobalPCname;
    private PieChart fTimeRangePC;
    private String fTimeRangePCname;
    private Listener fMouseMoveListener;
    private MouseListener fMouseClickListener;
    private ListenerList fEventTypeSelectedListeners = new ListenerList(1);
    private String fOthersSliceName;
    private IPieChartViewerState fCurrentState;
    private static final float MIN_PRECENTAGE_TO_SHOW_SLICE = 0.025f;
    private static final int NB_MAX_SLICES = 10;
    private TmfPieChartStatisticsModel fModel = null;
    private @NonNull TimeGraphColorScheme fColorScheme = new TimeGraphColorScheme();

    public TmfPieChartViewer(Composite parent) {
        super(parent, 0);
        this.fGlobalPCname = Messages.TmfStatisticsView_GlobalSelectionPieChartName;
        this.fTimeRangePCname = Messages.TmfStatisticsView_TimeRangeSelectionPieChartName;
        this.fOthersSliceName = Messages.TmfStatisticsView_PieChartOthersSliceName;
        parent.addDisposeListener(e -> this.fColorScheme.dispose());
        this.initContent();
    }

    private synchronized void initContent() {
        this.setLayout((Layout)new FillLayout());
        this.fGlobalPC = null;
        this.fTimeRangePC = null;
        this.fMouseMoveListener = new Listener(){

            public void handleEvent(Event event) {
                PieChart pc = (PieChart)event.widget;
                switch (event.type) {
                    case 5: {
                        int sliceIndex = pc.getSliceIndexFromPosition(0, event.x, event.y);
                        if (sliceIndex < 0) {
                            pc.setToolTipText(null);
                            break;
                        }
                        float percOfSlice = (float)pc.getSlicePercent(0, sliceIndex);
                        String percent = String.format("%.1f", Float.valueOf(percOfSlice));
                        Long nbEvents = (long)pc.getSeriesSet().getSeries()[sliceIndex].getXSeries()[0];
                        String text = String.valueOf(Messages.TmfStatisticsView_PieChartToolTipTextName) + " = " + pc.getSeriesSet().getSeries()[sliceIndex].getId() + "\n";
                        text = String.valueOf(text) + Messages.TmfStatisticsView_PieChartToolTipTextEventCount + " = " + nbEvents.toString() + " (" + percent + "%)";
                        pc.setToolTipText(text);
                        return;
                    }
                }
            }
        };
        this.fMouseClickListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                PieChart pc = (PieChart)e.widget;
                int slicenb = pc.getSliceIndexFromPosition(0, e.x, e.y);
                if (slicenb < 0 || slicenb >= pc.getSeriesSet().getSeries().length) {
                    return;
                }
                Event selectionEvent = new Event();
                selectionEvent.text = pc.getSeriesSet().getSeries()[slicenb].getId();
                TmfPieChartViewer.this.notifyEventTypeSelectionListener(selectionEvent);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.setCurrentState(new PieChartViewerStateNoContentSelected(this));
    }

    synchronized void updateGlobalPieChart() {
        if (this.getGlobalPC() == null) {
            this.fGlobalPC = new PieChart((Composite)this, 0);
            Color backgroundColor = this.fColorScheme.getColor(38);
            Color foregroundColor = this.fColorScheme.getColor(39);
            this.getGlobalPC().getTitle().setText(this.fGlobalPCname);
            this.getGlobalPC().getTitle().setForeground(foregroundColor);
            this.getGlobalPC().setBackground(backgroundColor);
            this.getGlobalPC().setForeground(foregroundColor);
            this.getGlobalPC().getAxisSet().getXAxis(0).getTitle().setText("");
            this.getGlobalPC().getAxisSet().getXAxis(0).getTitle().setForeground(foregroundColor);
            this.getGlobalPC().getLegend().setVisible(true);
            this.getGlobalPC().getLegend().setPosition(131072);
            this.getGlobalPC().getLegend().setBackground(backgroundColor);
            this.getGlobalPC().getLegend().setForeground(foregroundColor);
            this.getGlobalPC().addListener(5, this.fMouseMoveListener);
            this.getGlobalPC().addMouseListener(this.fMouseClickListener);
        } else if (this.getGlobalPC().isDisposed() || this.fModel == null || this.fModel.getPieChartGlobalModel() == null) {
            return;
        }
        Map<String, Long> totalEventCountForChart = this.getTotalEventCountForChart(true);
        if (totalEventCountForChart == null) {
            return;
        }
        TmfPieChartViewer.updatePieChartWithData(this.fGlobalPC, totalEventCountForChart, 0.025f, this.fOthersSliceName);
    }

    synchronized void updateTimeRangeSelectionPieChart() {
        if (this.getTimeRangePC() == null) {
            Color backgroundColor = this.fColorScheme.getColor(38);
            Color foregroundColor = this.fColorScheme.getColor(39);
            this.fTimeRangePC = new PieChart((Composite)this, 0);
            this.fTimeRangePC.setBackground(backgroundColor);
            this.fTimeRangePC.setForeground(foregroundColor);
            this.getTimeRangePC().getTitle().setText(this.fTimeRangePCname);
            this.getTimeRangePC().getTitle().setForeground(foregroundColor);
            this.getTimeRangePC().getAxisSet().getXAxis(0).getTitle().setText("");
            this.getTimeRangePC().getAxisSet().getXAxis(0).getTitle().setForeground(foregroundColor);
            this.getTimeRangePC().getLegend().setPosition(1024);
            this.getTimeRangePC().getLegend().setVisible(true);
            this.getTimeRangePC().getLegend().setBackground(backgroundColor);
            this.getTimeRangePC().getLegend().setForeground(foregroundColor);
            this.getTimeRangePC().addListener(5, this.fMouseMoveListener);
            this.getTimeRangePC().addMouseListener(this.fMouseClickListener);
        } else if (this.getTimeRangePC().isDisposed()) {
            return;
        }
        Map<String, Long> totalEventCountForChart = this.getTotalEventCountForChart(false);
        if (totalEventCountForChart == null) {
            return;
        }
        TmfPieChartViewer.updatePieChartWithData(this.fTimeRangePC, totalEventCountForChart, 0.025f, this.fOthersSliceName);
    }

    private Map<String, Long> getTotalEventCountForChart(boolean isGlobal) {
        if (this.fModel == null) {
            return null;
        }
        Map<ITmfTrace, Map<String, Long>> chartModel = isGlobal ? this.fModel.getPieChartGlobalModel() : this.fModel.getPieChartSelectionModel();
        if (chartModel == null) {
            return null;
        }
        HashMap<String, Long> totalEventCountForChart = new HashMap<String, Long>();
        for (Map.Entry<ITmfTrace, Map<String, Long>> entry : chartModel.entrySet()) {
            Map<String, Long> traceEventCount = entry.getValue();
            if (traceEventCount == null) continue;
            for (Map.Entry<String, Long> event : traceEventCount.entrySet()) {
                Long value = (Long)totalEventCountForChart.get(event.getKey());
                if (value != null) {
                    totalEventCountForChart.put(event.getKey(), value + event.getValue());
                    continue;
                }
                totalEventCountForChart.put(event.getKey(), event.getValue());
            }
        }
        return totalEventCountForChart;
    }

    public synchronized void reinitializeCharts() {
        if (this.isDisposed()) {
            return;
        }
        if (this.getGlobalPC() != null && !this.getGlobalPC().isDisposed()) {
            this.getGlobalPC().dispose();
        }
        this.fGlobalPC = new PieChart((Composite)this, 0);
        this.getGlobalPC().getTitle().setText(this.fGlobalPCname);
        this.getGlobalPC().getAxisSet().getXAxis(0).getTitle().setText("");
        if (this.getTimeRangePC() != null && !this.getTimeRangePC().isDisposed()) {
            this.getTimeRangePC().dispose();
            this.fTimeRangePC = null;
        }
        this.layout();
        this.setCurrentState(new PieChartViewerStateNoContentSelected(this));
    }

    private static void updatePieChartWithData(PieChart chart, Map<String, Long> slices, float minimumSizeOfSlice, String nameOfOthers) {
        ArrayList<EventOccurrenceObject> chartValues = new ArrayList<EventOccurrenceObject>();
        Long eventTotal = 0L;
        for (Map.Entry<String, Long> entry : slices.entrySet()) {
            eventTotal = eventTotal + entry.getValue();
            chartValues.add(new EventOccurrenceObject(entry.getKey(), entry.getValue()));
        }
        if (eventTotal == 0L) {
            return;
        }
        ArrayList<EventOccurrenceObject> filteredChartValues = new ArrayList<EventOccurrenceObject>();
        Long othersEntryCount = 0L;
        int nbSlices = 0;
        for (EventOccurrenceObject entry : chartValues) {
            if ((float)entry.getNbOccurence().longValue() / eventTotal.floatValue() > minimumSizeOfSlice && nbSlices <= 10) {
                filteredChartValues.add(entry);
                ++nbSlices;
                continue;
            }
            othersEntryCount = othersEntryCount + entry.getNbOccurence();
        }
        Collections.sort(filteredChartValues);
        if (othersEntryCount != 0L) {
            filteredChartValues.add(new EventOccurrenceObject(nameOfOthers, othersEntryCount));
        }
        double[][] tempValues = new double[filteredChartValues.size()][1];
        String[] tempNames = new String[filteredChartValues.size()];
        int index = 0;
        for (EventOccurrenceObject entry : filteredChartValues) {
            tempValues[index][0] = entry.getNbOccurence().longValue();
            tempNames[index] = entry.getName();
            ++index;
        }
        chart.addPieChartSeries(tempNames, tempValues);
    }

    public synchronized void refresh(boolean refreshGlobal, boolean refreshSelection) {
        if (this.fModel == null) {
            this.reinitializeCharts();
        } else {
            if (refreshGlobal) {
                this.getCurrentState().newGlobalEntries(this);
            }
            if (refreshSelection) {
                int nbEventsType = 0;
                Map<String, Long> selectionModel = this.getTotalEventCountForChart(false);
                for (Long l : selectionModel.values()) {
                    if (l == 0L) continue;
                    ++nbEventsType;
                }
                if (nbEventsType < 2) {
                    this.getCurrentState().newEmptySelection(this);
                } else {
                    this.getCurrentState().newSelection(this);
                }
            }
        }
    }

    public void addEventTypeSelectionListener(Listener l) {
        this.fEventTypeSelectedListeners.add((Object)l);
    }

    public void removeEventTypeSelectionListener(Listener l) {
        this.fEventTypeSelectedListeners.remove((Object)l);
    }

    private void notifyEventTypeSelectionListener(Event e) {
        Object[] objectArray = this.fEventTypeSelectedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((Listener)o).handleEvent(e);
            ++n2;
        }
    }

    synchronized PieChart getGlobalPC() {
        return this.fGlobalPC;
    }

    synchronized PieChart getTimeRangePC() {
        return this.fTimeRangePC;
    }

    synchronized IPieChartViewerState getCurrentState() {
        return this.fCurrentState;
    }

    public TmfPieChartStatisticsModel getModel() {
        return this.fModel;
    }

    public void setInput(TmfPieChartStatisticsModel model) {
        this.fModel = model;
    }

    public synchronized void setTimeRangePC(PieChart newChart) {
        this.fTimeRangePC = newChart;
    }

    public synchronized void setCurrentState(IPieChartViewerState newState) {
        this.fCurrentState = newState;
    }

    private static class EventOccurrenceObject
    implements Comparable<EventOccurrenceObject> {
        private String fName;
        private Long fNbOccurrences;

        EventOccurrenceObject(String name, Long nbOccurences) {
            this.fName = name;
            this.fNbOccurrences = nbOccurences;
        }

        @Override
        public int compareTo(EventOccurrenceObject other) {
            return Long.compare(other.getNbOccurence(), this.getNbOccurence());
        }

        public String getName() {
            return this.fName;
        }

        public Long getNbOccurence() {
            return this.fNbOccurrences;
        }
    }
}

