/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.api.query.ToolSectionQuery;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.ToolSection;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.edit.api.part.ISiriusEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.draw2d.ui.figures.FigureUtilities;
import org.eclipse.sirius.diagram.ui.tools.internal.menu.LocationURI;
import org.eclipse.sirius.tools.api.ui.ExternalJavaActionProvider;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.GroupMenu;
import org.eclipse.sirius.viewpoint.description.tool.GroupMenuItem;
import org.eclipse.sirius.viewpoint.description.tool.MenuItemDescription;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.PopupMenu;
import org.eclipse.sirius.viewpoint.description.tool.ToolEntry;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PopupMenuContribution
implements IContributionItemProvider {
    private static final String DEFAULT_TABBAR_GROUP = "selectGroup";
    private boolean contributionToTabbar;

    public PopupMenuContribution() {
    }

    public PopupMenuContribution(boolean contributionToTabbar) {
        this.contributionToTabbar = contributionToTabbar;
    }

    public void contributeToActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public static void contributeToPopupMenuProgrammatically(IMenuManager menu, IWorkbenchPart part, boolean contributeToTabbar) {
        new PopupMenuContribution(contributeToTabbar).contributeToPopupMenu(menu, part);
    }

    public void contributeToPopupMenu(IMenuManager menu, IWorkbenchPart part) {
        if (part instanceof SiriusDiagramEditor) {
            SiriusDiagramEditor diagrampart = (SiriusDiagramEditor)part;
            Object adapter = diagrampart.getAdapter(IDiagramCommandFactoryProvider.class);
            if (adapter == null) {
                return;
            }
            TransactionalEditingDomain transactionalEditingDomain = diagrampart.getEditingDomain();
            IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
            IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
            EObject element = diagrampart.getDiagramEditPart().resolveSemanticElement();
            if (element instanceof DSemanticDiagram) {
                DSemanticDiagram designerDiag = (DSemanticDiagram)element;
                List layers = new DDiagramQuery((DDiagram)designerDiag).getAllActivatedLayers();
                Session session = SessionManager.INSTANCE.getSession(designerDiag.getTarget());
                BasicEList sections = new BasicEList();
                BasicEList activatedGroups = new BasicEList();
                BasicEList activatedPopupMenus = new BasicEList();
                BasicEList activatedOperationActionMenus = new BasicEList();
                BasicEList activatedExternalJavaActionMenus = new BasicEList();
                EList tools = designerDiag.getDescription().getReusedTools();
                this.computeReusedTools((EList<? extends ToolEntry>)tools, (EList<GroupMenu>)activatedGroups, (EList<PopupMenu>)activatedPopupMenus, (EList<ExternalJavaAction>)activatedExternalJavaActionMenus, (EList<OperationAction>)activatedOperationActionMenus);
                sections.addAll((Collection)new ToolSectionQuery(designerDiag.getDescription().getToolSection()).getAllSections());
                for (Layer layer : layers) {
                    for (ToolSection ts : layer.getToolSections()) {
                        sections.addAll((Collection)new ToolSectionQuery(ts).getAllSections());
                    }
                }
                for (ToolSection toolSection : sections) {
                    activatedGroups.addAll((Collection)toolSection.getGroups());
                    activatedPopupMenus.addAll((Collection)toolSection.getPopupMenus());
                    ToolSectionQuery toolSectionQuery = new ToolSectionQuery(toolSection);
                    activatedOperationActionMenus.addAll((Collection)toolSectionQuery.getOperationActions(session));
                    activatedExternalJavaActionMenus.addAll((Collection)toolSectionQuery.getExternalJavaActions(session));
                    this.computeReusedTools((EList<? extends ToolEntry>)toolSection.getReusedTools(), (EList<GroupMenu>)activatedGroups, (EList<PopupMenu>)activatedPopupMenus, (EList<ExternalJavaAction>)activatedExternalJavaActionMenus, (EList<OperationAction>)activatedOperationActionMenus);
                }
                EditDomain domain = null;
                EditPart primarySelection = null;
                ArrayList<DSemanticDecorator> selectedViews = new ArrayList<DSemanticDecorator>(diagrampart.getDiagramGraphicalViewer().getSelectedEditParts().size());
                for (EditPart editpart : diagrampart.getDiagramGraphicalViewer().getSelectedEditParts()) {
                    IGraphicalEditPart curPart;
                    EObject designerObj;
                    if (2 == editpart.getSelected()) {
                        primarySelection = editpart;
                    }
                    domain = editpart.getViewer().getEditDomain();
                    if (!(editpart instanceof IGraphicalEditPart) || !(editpart instanceof ISiriusEditPart) || !((designerObj = (curPart = (IGraphicalEditPart)editpart).resolveSemanticElement()) instanceof DSemanticDecorator)) continue;
                    selectedViews.add((DSemanticDecorator)designerObj);
                }
                if (diagrampart.getDiagramGraphicalViewer().getSelectedEditParts().size() == 0) {
                    domain = diagrampart.getDiagramEditPart().getViewer().getEditDomain();
                    selectedViews.add((DSemanticDecorator)designerDiag);
                    primarySelection = diagrampart.getDiagramEditPart();
                }
                if (domain != null && selectedViews.size() > 0) {
                    Point relativeCursorLocationToPrimarySelection = this.getCurrentLocation(primarySelection);
                    this.contributeToPopupMenu(menu, emfCommandFactory, session, (EList<GroupMenu>)activatedGroups, (EList<PopupMenu>)activatedPopupMenus, (EList<OperationAction>)activatedOperationActionMenus, (EList<ExternalJavaAction>)activatedExternalJavaActionMenus, domain, primarySelection, selectedViews, relativeCursorLocationToPrimarySelection);
                }
            }
        }
    }

    private void contributeToPopupMenu(IMenuManager menu, IDiagramCommandFactory emfCommandFactory, Session session, EList<GroupMenu> activatedGroups, EList<PopupMenu> activatedPopupMenus, EList<OperationAction> activatedOperationActionMenus, EList<ExternalJavaAction> activatedExternalJavaActionMenus, EditDomain domain, EditPart primarySelection, Collection<DSemanticDecorator> selectedViews, Point relativeCursorLocationToPrimarySelection) {
        if (!this.contributionToTabbar) {
            for (PopupMenu popMenu : new LinkedHashSet<PopupMenu>((Collection<PopupMenu>)activatedPopupMenus)) {
                this.addPopupMenu(popMenu, menu, null, domain, selectedViews, emfCommandFactory, primarySelection, relativeCursorLocationToPrimarySelection);
            }
        }
        for (GroupMenu group : new LinkedHashSet<GroupMenu>((Collection<GroupMenu>)activatedGroups)) {
            this.addItemToMenu((AbstractToolDescription)group, menu, null, selectedViews, domain, emfCommandFactory, session.getInterpreter(), primarySelection, relativeCursorLocationToPrimarySelection);
        }
        if (!this.contributionToTabbar) {
            for (OperationAction operationAction : new LinkedHashSet<OperationAction>((Collection<OperationAction>)activatedOperationActionMenus)) {
                this.addItemToMenu((AbstractToolDescription)operationAction, menu, null, selectedViews, domain, emfCommandFactory, session.getInterpreter(), primarySelection, relativeCursorLocationToPrimarySelection);
            }
            for (ExternalJavaAction externalJavaAction : new LinkedHashSet<ExternalJavaAction>((Collection<ExternalJavaAction>)activatedExternalJavaActionMenus)) {
                this.addItemToMenu((AbstractToolDescription)externalJavaAction, menu, null, selectedViews, domain, emfCommandFactory, session.getInterpreter(), primarySelection, relativeCursorLocationToPrimarySelection);
            }
        }
    }

    protected Point getCurrentLocation(EditPart primarySelection) {
        org.eclipse.swt.graphics.Point cursorLocation = PlatformUI.getWorkbench().getDisplay().getCursorLocation();
        FigureCanvas control = (FigureCanvas)primarySelection.getRoot().getViewer().getControl();
        org.eclipse.swt.graphics.Point screenRelativeSWTPoint = control.toControl(cursorLocation);
        EditPart editPartUnderMouse = primarySelection.getRoot().getViewer().findObjectAtExcluding(new Point(screenRelativeSWTPoint.x, screenRelativeSWTPoint.y), (Collection)Collections.EMPTY_LIST);
        Point currentLocation = new Point(screenRelativeSWTPoint.x, screenRelativeSWTPoint.y);
        if (editPartUnderMouse instanceof GraphicalEditPart) {
            IFigure fig = ((GraphicalEditPart)editPartUnderMouse).getFigure();
            fig.translateToRelative((Translatable)currentLocation);
            Point containerLocation = fig.getBounds().getLocation();
            currentLocation = new Point(currentLocation.x - Math.max(0, containerLocation.x), currentLocation.y - Math.max(0, containerLocation.y));
            if (fig instanceof ResizableCompartmentFigure) {
                Point scrollOffset = ((ResizableCompartmentFigure)fig).getScrollPane().getViewport().getViewLocation();
                Point shiftFromMarginOffset = FigureUtilities.getShiftFromMarginOffset((ResizableCompartmentFigure)fig, false, editPartUnderMouse);
                currentLocation = new Point(currentLocation.x + scrollOffset.x - shiftFromMarginOffset.x, currentLocation.y + scrollOffset.y - shiftFromMarginOffset.y);
            }
        }
        return currentLocation;
    }

    private void computeReusedTools(EList<? extends ToolEntry> reusedTools, EList<GroupMenu> activatedGroups, EList<PopupMenu> activatedPopupMenus, EList<ExternalJavaAction> activatedExternalJavaActionMenus, EList<OperationAction> activatedOperationActionMenus) {
        for (ToolEntry abstractToolDescription : reusedTools) {
            if (abstractToolDescription instanceof GroupMenu) {
                activatedGroups.add((Object)((GroupMenu)abstractToolDescription));
                continue;
            }
            if (abstractToolDescription instanceof PopupMenu) {
                activatedPopupMenus.add((Object)((PopupMenu)abstractToolDescription));
                continue;
            }
            if (abstractToolDescription instanceof OperationAction) {
                activatedOperationActionMenus.add((Object)((OperationAction)abstractToolDescription));
                continue;
            }
            if (!(abstractToolDescription instanceof ExternalJavaAction)) continue;
            activatedExternalJavaActionMenus.add((Object)((ExternalJavaAction)abstractToolDescription));
        }
    }

    private Boolean preconditionHolds(AbstractToolDescription menuOrGroupItem, Collection<DSemanticDecorator> selectedViews, EObject semantic, IInterpreter interpreter) {
        Boolean precondition;
        if (StringUtil.isEmpty((String)menuOrGroupItem.getPrecondition())) {
            precondition = true;
        } else {
            if (menuOrGroupItem instanceof OperationAction) {
                interpreter.setVariable(((OperationAction)menuOrGroupItem).getView().getName(), selectedViews);
            }
            try {
                precondition = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(semantic, (EObject)menuOrGroupItem, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
            }
            finally {
                if (menuOrGroupItem instanceof OperationAction) {
                    interpreter.unSetVariable(((OperationAction)menuOrGroupItem).getView().getName());
                }
            }
        }
        return precondition;
    }

    private void addItemToMenu(AbstractToolDescription menuOrGroupItem, IMenuManager parentMenu, String groupId, Collection<DSemanticDecorator> selectedViews, EditDomain domain, IDiagramCommandFactory emfCommandFactory, IInterpreter interpreter, EditPart primarySelection, Point currentMouseLocation) {
        EObject semantic = selectedViews.iterator().next().getTarget();
        if (interpreter != null && this.preconditionHolds(menuOrGroupItem, selectedViews, semantic, interpreter).booleanValue()) {
            IAction action;
            OperationAction operation;
            if (menuOrGroupItem instanceof GroupMenu) {
                this.addGroup((GroupMenu)menuOrGroupItem, parentMenu, domain, selectedViews, emfCommandFactory, primarySelection, currentMouseLocation);
            } else if (menuOrGroupItem instanceof PopupMenu) {
                this.addPopupMenu((PopupMenu)menuOrGroupItem, parentMenu, groupId, domain, selectedViews, emfCommandFactory, primarySelection, currentMouseLocation);
            } else if (menuOrGroupItem instanceof ExternalJavaAction) {
                IAction action2;
                ExternalJavaAction javaAction = (ExternalJavaAction)menuOrGroupItem;
                if (javaAction.getId() != null && !"".equalsIgnoreCase(javaAction.getId()) && (action2 = this.buildJavaAction(javaAction, selectedViews, domain, emfCommandFactory, interpreter, currentMouseLocation)) != null) {
                    this.addActionInGroup(parentMenu, groupId, action2);
                }
            } else if (menuOrGroupItem instanceof OperationAction && (operation = (OperationAction)menuOrGroupItem).getInitialOperation().getFirstModelOperations() != null && (action = this.buildOperationAction(operation, selectedViews, domain, emfCommandFactory, primarySelection, currentMouseLocation)) != null) {
                this.addActionInGroup(parentMenu, groupId, action);
            }
        }
    }

    private IAction buildJavaAction(ExternalJavaAction javaActionMenuItem, Collection<DSemanticDecorator> selectedViews, final EditDomain domain, IDiagramCommandFactory emfCommandFactory, IInterpreter interpreter, Point currentMouseLocation) {
        IExternalJavaAction javaAction = ExternalJavaActionProvider.INSTANCE.getJavaActionById(javaActionMenuItem.getId());
        Action result = null;
        ImageDescriptor imageDescriptor = null;
        if (javaAction != null) {
            Command command = emfCommandFactory.buildJavaActionFromTool(javaActionMenuItem, selectedViews, javaAction);
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)((EObject)selectedViews.iterator().next()));
            final GMFCommandWrapper gefCommandWrapper = new GMFCommandWrapper(transactionalEditingDomain, command);
            if (command.canExecute()) {
                if (javaActionMenuItem.getIcon() != null && !"".equals(javaActionMenuItem.getIcon())) {
                    imageDescriptor = DiagramUIPlugin.Implementation.findImageDescriptor(javaActionMenuItem.getIcon());
                }
                result = new Action(new IdentifiedElementQuery((IdentifiedElement)javaActionMenuItem).getLabel(), imageDescriptor){

                    public void run() {
                        super.run();
                        domain.getCommandStack().execute((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)gefCommandWrapper));
                    }
                };
            }
        }
        return result;
    }

    private IAction buildOperationAction(OperationAction operationAction, Collection<DSemanticDecorator> selectedViews, final EditDomain domain, IDiagramCommandFactory emfCommandFactory, final EditPart primarySelection, final Point currentMouseLocation) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)((EObject)selectedViews.iterator().next()));
        Command command = emfCommandFactory.buildOperationActionFromTool(operationAction, selectedViews);
        final CompoundCommand cc = new CompoundCommand(command.getLabel());
        cc.add(new org.eclipse.gef.commands.Command(org.eclipse.sirius.diagram.ui.provider.Messages.PopupMenuContribution_storeMouseLocationCmdLabel){

            public void execute() {
                SiriusLayoutDataManager.INSTANCE.addData(new RootLayoutData(primarySelection, currentMouseLocation.getCopy(), new Dimension(-1, -1)));
            }
        });
        cc.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)new GMFCommandWrapper(transactionalEditingDomain, command)));
        ImageDescriptor imageDescriptor = null;
        if (operationAction.getIcon() != null && !"".equals(operationAction.getIcon())) {
            imageDescriptor = DiagramUIPlugin.Implementation.findImageDescriptor(operationAction.getIcon());
        }
        return new Action(MessageTranslator.INSTANCE.getMessage((EObject)operationAction, new IdentifiedElementQuery((IdentifiedElement)operationAction).getLabel()), imageDescriptor){

            public void run() {
                super.run();
                domain.getCommandStack().execute((org.eclipse.gef.commands.Command)cc);
            }
        };
    }

    public void disposeContributions(IWorkbenchPartDescriptor arg0) {
    }

    public void updateActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void addProviderChangeListener(IProviderChangeListener arg0) {
    }

    public boolean provides(IOperation arg0) {
        return true;
    }

    public void removeProviderChangeListener(IProviderChangeListener arg0) {
    }

    private void addActionInGroup(IMenuManager parentMenu, String groupId, IAction action) {
        if (this.contributionToTabbar && DEFAULT_TABBAR_GROUP.equals(groupId)) {
            parentMenu.insertAfter("toolbarSelectAllShapesAction", action);
        } else {
            try {
                parentMenu.appendToGroup(groupId, action);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    parentMenu.appendToGroup("additions", action);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    parentMenu.add((IContributionItem)new Separator("additions"));
                    parentMenu.appendToGroup("additions", action);
                }
            }
        }
    }

    private void addMenuInGroup(IMenuManager parentMenu, String groupId, IContributionItem menu) {
        try {
            parentMenu.appendToGroup(groupId, menu);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                parentMenu.appendToGroup("additions", menu);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                parentMenu.add((IContributionItem)new Separator("additions"));
                parentMenu.appendToGroup("additions", menu);
            }
        }
    }

    private void addPopupMenu(PopupMenu popupMenu, IMenuManager parentMenu, String groupId, EditDomain domain, Collection<DSemanticDecorator> selectedViews, IDiagramCommandFactory emfCommandFactory, EditPart primarySelection, Point currentMouseLocation) {
        EObject semantic = selectedViews.iterator().next().getTarget();
        EList activatedGroupsOrActions = popupMenu.getMenuItemDescription();
        IInterpreter interpreter = null;
        if (semantic != null && semantic.eResource() != null) {
            interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
        } else if (semantic instanceof DMappingBased) {
            interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)((DMappingBased)semantic).getMapping());
        }
        Boolean isMenuPreconditionValidated = StringUtil.isEmpty((String)popupMenu.getPrecondition()) ? Boolean.valueOf(true) : Boolean.valueOf(RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(semantic, (EObject)popupMenu, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition()));
        if (isMenuPreconditionValidated.booleanValue()) {
            String menuId = popupMenu.getName();
            IMenuManager subMenu = parentMenu.findMenuUsingPath(menuId);
            if (subMenu == null) {
                subMenu = new MenuManager(MessageTranslator.INSTANCE.getMessage((EObject)popupMenu, new IdentifiedElementQuery((IdentifiedElement)popupMenu).getLabel()), menuId);
                subMenu.add((IContributionItem)new Separator("additions"));
            }
            for (MenuItemDescription menuItemDescription : activatedGroupsOrActions) {
                this.addItemToMenu((AbstractToolDescription)menuItemDescription, subMenu, null, selectedViews, domain, emfCommandFactory, interpreter, primarySelection, currentMouseLocation);
            }
            if (!parentMenu.equals(subMenu) && subMenu instanceof ContributionManager && ((ContributionManager)subMenu).getSize() > 0) {
                subMenu.setVisible(true);
                this.addMenuInGroup(parentMenu, groupId, (IContributionItem)subMenu);
            }
        }
    }

    private void addGroup(GroupMenu group, IMenuManager parentMenu, EditDomain domain, Collection<DSemanticDecorator> selectedViews, IDiagramCommandFactory emfCommandFactory, EditPart primarySelection, Point currentMouseLocation) {
        EObject semantic = selectedViews.iterator().next().getTarget();
        IMenuManager menuContainingNewGroup = null;
        String locationURI = group.getLocationURI();
        if (group.eContainer() instanceof PopupMenu) {
            if (locationURI != null && !locationURI.isEmpty()) {
                DiagramUIPlugin.getPlugin().log(new Status(2, "org.eclipse.sirius.diagram.ui", 0, MessageFormat.format(org.eclipse.sirius.diagram.ui.provider.Messages.Group_Not_Displayed, group.getName(), MessageFormat.format(Messages.Constraint_validNullLocationURIForGroupInPopupMenuConstraint_message, group.getLocationURI())), null));
            } else {
                menuContainingNewGroup = parentMenu;
            }
        } else {
            try {
                LocationURI locationURIQuery = new LocationURI(locationURI);
                if (!this.contributionToTabbar && locationURIQuery.getMenuId().isPresent()) {
                    String menuId = locationURIQuery.getMenuId().get();
                    if ("root".equals(menuId)) {
                        menuContainingNewGroup = parentMenu;
                    } else {
                        menuContainingNewGroup = parentMenu.findMenuUsingPath(menuId);
                        if (menuContainingNewGroup == null) {
                            DiagramUIPlugin.getPlugin().log(new Status(2, "org.eclipse.sirius.diagram.ui", 0, MessageFormat.format(org.eclipse.sirius.diagram.ui.provider.Messages.Group_Not_Displayed, group.getName(), MessageFormat.format(org.eclipse.sirius.diagram.ui.provider.Messages.Group_No_Menu_ID, menuId)), null));
                        }
                    }
                } else if (this.contributionToTabbar && locationURIQuery.getTabbarId().isPresent() && locationURIQuery.getTabbarId().get().equals(parentMenu.getId())) {
                    menuContainingNewGroup = parentMenu;
                }
            }
            catch (URISyntaxException e) {
                DiagramUIPlugin.getPlugin().log(new Status(2, "org.eclipse.sirius.diagram.ui", 0, MessageFormat.format(org.eclipse.sirius.diagram.ui.provider.Messages.Group_Not_Displayed, group.getName(), e.getMessage()), (Throwable)e));
            }
        }
        if (menuContainingNewGroup != null) {
            IContributionItem existingSeparator = menuContainingNewGroup.findUsingPath(group.getName());
            if (!(existingSeparator instanceof Separator || this.contributionToTabbar && DEFAULT_TABBAR_GROUP.equals(group.getName()))) {
                menuContainingNewGroup.add((IContributionItem)new Separator(group.getName()));
            }
            EList activatedMenusOrActions = group.getItemDescriptions();
            IInterpreter interpreter = null;
            if (semantic != null && semantic.eResource() != null) {
                interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
            } else if (semantic instanceof DMappingBased) {
                interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)((DMappingBased)semantic).getMapping());
            }
            Boolean isGroupPreconditionValidated = StringUtil.isEmpty((String)group.getPrecondition()) ? Boolean.valueOf(true) : Boolean.valueOf(RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(semantic, (EObject)group, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition()));
            if (isGroupPreconditionValidated.booleanValue()) {
                for (GroupMenuItem menuItemDescription : activatedMenusOrActions) {
                    this.addItemToMenu((AbstractToolDescription)menuItemDescription, menuContainingNewGroup, group.getName(), selectedViews, domain, emfCommandFactory, interpreter, primarySelection, currentMouseLocation);
                }
            }
        }
    }
}

