/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.rse.ui.view;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.eclipse.condition.RemoteSystemExists;
import org.eclipse.reddeer.eclipse.condition.RemoteSystemIsConnected;
import org.eclipse.reddeer.eclipse.rse.ui.dialogs.SystemPasswordPromptDialog;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;

public class System {
    private static final TimePeriod TIMEOUT = TimePeriod.VERY_LONG;
    private static final Logger log = Logger.getLogger(System.class);
    protected TreeItem treeItem;
    protected String label;

    public System(TreeItem treeItem) {
        this.treeItem = treeItem;
        this.label = treeItem.getText();
    }

    public String getLabel() {
        return this.label;
    }

    public void connect(String username) {
        this.connect(username, "");
    }

    public void connect(String username, String password) {
        this.connect(username, password, TimePeriod.DEFAULT);
    }

    public void connect(String username, String password, TimePeriod timeout) {
        log.info("Connecting to remote system " + this.getLabel());
        this.select();
        new ContextMenuItem(new String[]{"Connect"}).select();
        SystemPasswordPromptDialog systemPassDialog = new SystemPasswordPromptDialog();
        systemPassDialog.setUserID(username);
        systemPassDialog.setPassword(password);
        systemPassDialog.OK();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Warning"), timeout, false);
        try {
            DefaultShell authenticityShell = new DefaultShell("Warning");
            new YesButton().click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)authenticityShell), timeout);
            try {
                DefaultShell knownHosts = new DefaultShell("Warning");
                new YesButton().click();
                new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)knownHosts), timeout);
            }
            catch (RedDeerException redDeerException) {
                log.debug("Known_hosts shell was not opened");
            }
        }
        catch (RedDeerException redDeerException) {
            log.debug("Authenticity shell was not opened");
        }
        new WaitUntil((WaitCondition)new RemoteSystemIsConnected(this), timeout);
    }

    public void disconnect() {
        log.info("Disconnecting from remote system " + this.getLabel());
        this.select();
        new ContextMenuItem(new String[]{"Disconnect"}).select();
        new WaitWhile((WaitCondition)new RemoteSystemIsConnected(this));
    }

    public boolean isConnected() {
        this.select();
        try {
            new ContextMenuItem(new String[]{"Disconnect"});
        }
        catch (CoreLayerException coreLayerException) {
            return false;
        }
        return true;
    }

    protected void select() {
        this.treeItem.select();
    }

    public void delete() {
        log.info("Deleting system " + this.getLabel());
        if (this.getLabel().equals("Local")) {
            log.info("Local System cannot be deleted, skipping");
            return;
        }
        this.select();
        if (this.isConnected()) {
            this.disconnect();
        }
        new ContextMenuItem(new String[]{"Delete..."}).select();
        DefaultShell deleteShell = new DefaultShell("Delete Confirmation");
        new PushButton("Delete").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)deleteShell));
        new WaitWhile((WaitCondition)new RemoteSystemExists(this.getLabel()), TIMEOUT);
        new WaitWhile((WaitCondition)new JobIsRunning(), TIMEOUT);
    }
}

