/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.wizards;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathUtils;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.ui.wizards.PHPUnitWizard;
import org.eclipse.php.phpunit.ui.wizards.TestSuiteWizardPage;
import org.eclipse.php.phpunit.ui.wizards.templates.TestSuiteTemplate;

public class TestSuiteWizard
extends PHPUnitWizard {
    public TestSuiteWizard() {
        this.setWindowTitle(PHPUnitMessages.TestSuiteWizard_0);
        this.setDefaultPageImageDescriptor(PHPUnitPlugin.getImageDescriptor("wizban/newsuite_wiz.png"));
    }

    public void addPages() {
        this.page = new TestSuiteWizardPage();
        this.addPage((IWizardPage)this.page);
        this.page.init(this.getSelection());
    }

    @Override
    String generateFile() {
        TestSuiteTemplate template = new TestSuiteTemplate();
        try {
            template.resolveTemplate();
            template.setTestClassParams(this.page.getClassName(), this.page.getTestContainer().getFullPath().append(this.page.getFileName()).toOSString());
            template.setTestSuperClass(this.page.getSuperClass(), this.page.getSuperClassName(), this.page.getTestContainer().getProject());
            IType[] tests = ((TestSuiteWizardPage)this.page).getElementsToTest();
            if (tests != null) {
                int i = 0;
                while (i < tests.length) {
                    template.addTest(tests[i].getElementName());
                    IPath relativeLocation = IncludePathUtils.getRelativeLocationFromIncludePath((IScriptProject)tests[i].getScriptProject(), (IModelElement)tests[i]);
                    if (!relativeLocation.isEmpty()) {
                        template.addRequire(relativeLocation.toOSString());
                    }
                    ++i;
                }
            }
            template.compileTests();
            return template.compileTemplate();
        }
        catch (IOException e) {
            PHPUnitPlugin.log(e);
            return "";
        }
    }
}

