/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.photran.internal.core.lexer.SingleCharReader;

public final class LineAppendingReader
extends SingleCharReader {
    private Reader originalReader;
    private Reader eolReader;
    private Reader currentReader;
    private int lastChar = -1;

    public LineAppendingReader(Reader streamToWrap) {
        this.originalReader = streamToWrap;
        this.eolReader = new EOLReader();
        this.currentReader = this.originalReader;
    }

    @Override
    public int read() throws IOException {
        int result = this.currentReader.read();
        if (result == -1 && this.currentReader == this.originalReader && !this.isEOL(this.lastChar)) {
            this.currentReader = this.eolReader;
            result = this.currentReader.read();
        } else {
            this.lastChar = result;
        }
        return result;
    }

    private boolean isEOL(int c) {
        return c == 10 || c == 13;
    }

    @Override
    public void close() throws IOException {
        this.originalReader.close();
    }

    private static class EOLReader
    extends SingleCharReader {
        private static final byte[] EOL = System.getProperty("line.separator").getBytes();
        private int eolByte = 0;

        private EOLReader() {
        }

        @Override
        public int read() throws IOException {
            return this.eolByte < EOL.length ? EOL[this.eolByte++] : -1;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

