/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.Utilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class ShowDescriptionAction
extends Action {
    private String fPointID;
    private ISchema fSchema;
    private File fPreviewFile;
    private boolean fForceExternal;
    private static File fTempWorkingDir;

    public ShowDescriptionAction(String pointID) {
        this.fPointID = pointID;
        this.initialize();
    }

    public ShowDescriptionAction(IPluginExtensionPoint point) {
        this(point, false);
    }

    public ShowDescriptionAction(IPluginExtensionPoint point, boolean forceExternal) {
        this.setExtensionPoint(point.getFullId());
        this.fForceExternal = forceExternal;
        this.initialize();
    }

    public ShowDescriptionAction(IPluginExtensionPoint point, String pointID) {
        this.setExtensionPoint(pointID);
        this.fForceExternal = false;
        this.initialize();
    }

    public ShowDescriptionAction(ISchema schema) {
        this.setSchema(schema);
        this.initialize();
    }

    private void initialize() {
        this.setImageDescriptor(PDEPluginImages.DESC_DOC_SECTION_OBJ);
    }

    public void setSchema(ISchema schema) {
        this.fSchema = schema;
        this.fPointID = schema.getQualifiedPointId();
    }

    public void setExtensionPoint(String pointID) {
        this.fPointID = pointID;
        this.setText(PDEUIMessages.ShowDescriptionAction_label);
        this.fSchema = null;
    }

    public void run() {
        if (this.fSchema == null) {
            IPluginExtensionPoint point = PDECore.getDefault().getExtensionsRegistry().findExtensionPoint(this.fPointID);
            URL url = null;
            if (point != null && (url = SchemaRegistry.getSchemaURL((IPluginExtensionPoint)point)) != null) {
                SchemaDescriptor desc = new SchemaDescriptor(this.fPointID, url);
                this.fSchema = desc.getSchema(false);
            }
            if (point == null || url == null || this.fSchema == null) {
                this.showNoSchemaMessage();
                return;
            }
        }
        this.showSchemaDocument();
    }

    private void showNoSchemaMessage() {
        String title = PDEUIMessages.ShowDescriptionAction_title;
        String message = this.fPointID == null || this.fPointID.startsWith("null") ? PDEUIMessages.ShowDescriptionAction_schemaNotAvail : NLS.bind((String)PDEUIMessages.ShowDescriptionAction_noPoint_desc, (Object)this.fPointID);
        MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showSchemaDocument() {
        this.fPreviewFile = this.getTempPreviewFile();
        if (this.fPreviewFile == null) {
            return;
        }
        SchemaTransformer transformer = new SchemaTransformer();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream os = new FileOutputStream(this.fPreviewFile);
                try {
                    try (PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8), true);){
                        transformer.transform(this.fSchema, printWriter);
                        os.flush();
                        ((OutputStream)os).close();
                        this.showURL(this.fPreviewFile, this.fForceExternal);
                        this.linkPreviewFileToSchemaFile();
                    }
                    if (os == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (os == null) throw throwable;
                    ((OutputStream)os).close();
                    throw throwable;
                }
                ((OutputStream)os).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    private File getTempWorkingDir() throws IOException {
        if (fTempWorkingDir == null) {
            fTempWorkingDir = Utilities.createWorkingDirectory();
        }
        return fTempWorkingDir;
    }

    private File getTempPreviewFile() {
        File tempWorkingDir = null;
        try {
            tempWorkingDir = this.getTempWorkingDir();
        }
        catch (IOException iOException) {
            return null;
        }
        StringBuilder previewFileName = new StringBuilder();
        previewFileName.append("pde_schema_");
        previewFileName.append(this.fSchema.getQualifiedPointId().replace('.', '-'));
        previewFileName.append("_preview.html");
        File previewFile = new File(String.valueOf(tempWorkingDir.getPath()) + File.separatorChar + previewFileName.toString());
        if (!previewFile.exists()) {
            try {
                previewFile.createNewFile();
            }
            catch (IOException iOException) {
                return null;
            }
            previewFile.deleteOnExit();
        }
        return previewFile;
    }

    private void linkPreviewFileToSchemaFile() {
        if (this.fPreviewFile == null) {
            return;
        }
        IFile schemaFile = this.getSchemaFile();
        if (schemaFile == null) {
            return;
        }
        try {
            schemaFile.setSessionProperty(PDECore.SCHEMA_PREVIEW_FILE, (Object)this.fPreviewFile);
        }
        catch (CoreException coreException) {}
    }

    private IFile getSchemaFile() {
        if (this.fSchema == null) {
            return null;
        }
        File javaSchemaFile = new File(this.fSchema.getURL().getFile());
        IFile[] eclipseSchemaFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(javaSchemaFile.toURI());
        if (eclipseSchemaFiles.length == 0) {
            return null;
        }
        return eclipseSchemaFiles[0];
    }

    private void showURL(File file, boolean forceExternal) {
        try {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            URL url = file.toURL();
            if (forceExternal) {
                IWebBrowser browser = support.getExternalBrowser();
                browser.openURL(url);
            } else {
                IWebBrowser browser = support.createBrowser(40, file.getName(), this.fPointID, this.fPointID);
                browser.openURL(url);
            }
        }
        catch (MalformedURLException e) {
            PDEPlugin.logException(e);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }
}

