/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.filters.AbstractEventFilter;
import org.eclipse.ocl.examples.eventmanager.filters.LogicalOperationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogicalOperationFilterImpl
extends AbstractEventFilter
implements LogicalOperationFilter {
    private Set<EventFilter> filters = new HashSet<EventFilter>();

    @Override
    public Set<EventFilter> getOperands() {
        return Collections.unmodifiableSet(this.filters);
    }

    protected void clearOperands() {
        this.filters.clear();
    }

    protected void addOperand(EventFilter filter) {
        this.filters.add(filter);
    }

    protected void addOperands(Collection<EventFilter> filters) {
        this.filters.addAll(filters);
    }

    protected EventFilter[] cloneContents() {
        HashSet<EventFilter> clonedContent = new HashSet<EventFilter>();
        for (EventFilter filter : this.filters) {
            clonedContent.add(filter.clone());
        }
        EventFilter[] cloned = clonedContent.toArray(new EventFilter[clonedContent.size()]);
        return cloned;
    }

    public LogicalOperationFilterImpl(EventFilter ... filters) {
        super(false);
        this.filters.addAll(Arrays.asList(filters));
    }

    @Override
    public Object getFilterCriterion() {
        HashSet<Object> result = new HashSet<Object>();
        for (EventFilter f : this.getOperands()) {
            result.add(f.getFilterCriterion());
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogicalOperationFilterImpl other = (LogicalOperationFilterImpl)obj;
        if (this.filters == null ? other.filters != null : !this.filters.equals(other.filters)) {
            return false;
        }
        return this.isNegated() == other.isNegated();
    }

    @Override
    public void setNegated(boolean b) {
        if (b) {
            throw new IllegalArgumentException("logical filters are not allowed to be negated");
        }
    }

    @Override
    public boolean isNegated() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filters == null ? 0 : this.filters.hashCode());
        if (this.isNegated()) {
            result *= 31;
        }
        return result;
    }
}

