/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.dialogs;

import org.eclipse.emf.facet.widgets.celleditors.ICompositeEditorFactory;
import org.eclipse.emf.facet.widgets.celleditors.core.composite.registry.ICompositeEditorFactoriesRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.ui.internal.celleditors.composite.ComposedCellEditor;
import org.eclipse.modisco.infra.discovery.ui.internal.celleditors.composite.IComposedCellEditorListener;
import org.eclipse.modisco.infra.discovery.ui.internal.dialogs.GenericParametersDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class ParameterValueEditingSupport
extends EditingSupport {
    private final GenericParametersDialog genericParametersDialog;

    public ParameterValueEditingSupport(ColumnViewer viewer, GenericParametersDialog genericParametersDialog) {
        super(viewer);
        this.genericParametersDialog = genericParametersDialog;
    }

    protected boolean canEdit(Object element) {
        DiscovererParameter parameter = (DiscovererParameter)element;
        return ICompositeEditorFactoriesRegistry.INSTANCE.hasCompositeEditorFactory(parameter.getType());
    }

    protected CellEditor getCellEditor(Object element) {
        DiscovererParameter parameter = (DiscovererParameter)element;
        ICompositeEditorFactory compositeEditorFactory = ICompositeEditorFactoriesRegistry.INSTANCE.getCompositeEditorFactory(parameter.getType());
        Table table = ((TableViewer)this.getViewer()).getTable();
        ComposedCellEditor composedCellEditor = new ComposedCellEditor((Composite)table, compositeEditorFactory);
        this.cellEditorOpened();
        composedCellEditor.addListener(new IComposedCellEditorListener(){

            public void deactivated() {
                ParameterValueEditingSupport.this.cellEditorClosed();
            }
        });
        return composedCellEditor;
    }

    private void cellEditorOpened() {
        if (!this.genericParametersDialog.isCellEditorOpened()) {
            this.genericParametersDialog.setCellEditorOpened(true);
            this.genericParametersDialog.validate(true);
        }
    }

    protected void cellEditorClosed() {
        if (this.genericParametersDialog.isCellEditorOpened()) {
            this.genericParametersDialog.setCellEditorOpened(false);
            this.genericParametersDialog.validate(true);
        }
    }

    protected Object getValue(Object element) {
        return this.genericParametersDialog.getParameterValue((DiscovererParameter)element);
    }

    protected void setValue(Object element, Object value) {
        this.genericParametersDialog.setParameterValue((DiscovererParameter)element, value);
        this.getViewer().update(element, null);
        this.genericParametersDialog.validate(true);
    }
}

