/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPFormatHandler
extends AbstractHandler {
    private LSPFormatter formatter = new LSPFormatter();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            IDocument document = LSPEclipseUtils.getDocument(textEditor);
            Shell shell = textEditor.getSite().getShell();
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (document != null && selection instanceof ITextSelection) {
                this.formatter.requestFormatting(document, (ITextSelection)selection).thenAccept(edits -> shell.getDisplay().asyncExec(() -> this.formatter.applyEdits(document, (List<? extends TextEdit>)edits)));
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof ITextEditor) {
            List<LanguageServiceAccessor.LSPDocumentInfo> infos = LanguageServiceAccessor.getLSPDocumentInfosFor(LSPEclipseUtils.getDocument((ITextEditor)part), capabilities -> LSPFormatter.supportFormatting(capabilities));
            ISelection selection = ((ITextEditor)part).getSelectionProvider().getSelection();
            return !infos.isEmpty() && !selection.isEmpty() && selection instanceof ITextSelection;
        }
        return false;
    }
}

