/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.support.lua51.internal.validator;

import com.naef.jnlua.LuaRuntimeException;
import com.naef.jnlua.LuaState;
import com.naef.jnlua.eclipse.AbstractLuaModule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ldt.core.grammar.ILuaSourceValidator;
import org.eclipse.ldt.support.lua51.internal.Activator;

public class Lua51SourceValidator
extends AbstractLuaModule
implements ILuaSourceValidator {
    private static final String VALIDATOR_PATH = "script/internal";
    private static final String MODULE_NAME = "lua51validator";
    private static final String VALIDATION_FUNCTION = "valid";
    private LuaState lua;
    private String cleanedSource;
    private String errorMessage;
    private int lineIndex;

    public boolean valid(String source) {
        if (this.lua == null) {
            this.lua = this.loadLuaModule();
        }
        this.pushLuaModule(this.lua);
        this.lua.getField(-1, VALIDATION_FUNCTION);
        this.lua.pushString(source);
        try {
            this.lua.call(1, 3);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning("validation 5.1 failed", e);
            this.cleanedSource = null;
            this.errorMessage = "Unexpected error ...";
            this.lineIndex = 0;
            return false;
        }
        this.cleanedSource = this.lua.toString(-3);
        this.errorMessage = this.lua.toString(-2);
        this.lineIndex = Math.max(this.lua.toInteger(-1) - 1, 0);
        return this.errorMessage == null;
    }

    protected List<String> getLuaSourcePaths() {
        ArrayList<String> sourcepaths = new ArrayList<String>();
        sourcepaths.add(VALIDATOR_PATH);
        return sourcepaths;
    }

    protected List<String> getLuacSourcePaths() {
        return null;
    }

    protected LuaState createLuaState() {
        LuaState l = new LuaState();
        l.openLibs();
        return l;
    }

    protected String getPluginID() {
        return "org.eclipse.ldt.support.lua51";
    }

    protected String getModuleName() {
        return MODULE_NAME;
    }

    public String getCleanedSource() {
        return this.cleanedSource;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getLineIndex() {
        return this.lineIndex;
    }
}

