/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class SelectJarWizardPage
extends WizardPage {
    protected Tree jarTree;
    protected Text jarField;
    protected Text methodField;
    protected Text classField;
    protected String filePath;
    protected TreeViewer jarViewer;
    protected JarContentProvider contentProvider;
    protected Text webserviceOperation;
    protected Text webserviceInterface;
    protected Button webserviceCheckbox;
    protected boolean isWebservice;
    protected ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SelectJarWizardPage.this.setPageComplete(SelectJarWizardPage.this.validatePage());
        }
    };
    protected SelectionListener selListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            JarNode selection;
            if (SelectJarWizardPage.this.jarTree.getSelection()[0].getData() instanceof JarNode && (selection = (JarNode)((Object)SelectJarWizardPage.this.jarTree.getSelection()[0].getData())).getJarEntry() != null) {
                String name = selection.getJarEntry().getName();
                name = name.replace('/', '.');
                String s = ".class";
                if (name.endsWith(s = s.toLowerCase())) {
                    name = name.substring(0, name.length() - 6);
                }
                SelectJarWizardPage.this.classField.setText(name);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public SelectJarWizardPage(String pageId) {
        super(pageId);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label jarLabel = new Label(composite, 131072);
        jarLabel.setText(String.valueOf(org.eclipse.jwt.meta.PluginProperties.model_Application_jarArchive_name) + ":");
        this.jarField = new Text(composite, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.jarField.setLayoutData((Object)data);
        Button browseButton = new Button(composite, 8);
        browseButton.setText(PluginProperties.browse_button);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String[] filterExtensions = new String[]{"*.jar"};
                String[] extensionNames = new String[]{PluginProperties.wizards_Files_jarfiles};
                FileDialog fileDialog = new FileDialog(SelectJarWizardPage.this.getShell(), 4096);
                fileDialog.setFilterExtensions(filterExtensions);
                fileDialog.setFilterNames(extensionNames);
                fileDialog.open();
                if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
                    SelectJarWizardPage.this.filePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
                }
                SelectJarWizardPage.this.jarField.setText(SelectJarWizardPage.this.filePath);
                SelectJarWizardPage.this.setTreeViewerInput();
            }
        });
        this.jarTree = new Tree(composite, 4);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 4;
        data2.horizontalSpan = 3;
        this.jarTree.setLayoutData((Object)data2);
        this.jarViewer = new TreeViewer(this.jarTree);
        this.contentProvider = new JarContentProvider();
        this.jarViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.jarViewer.setLabelProvider((IBaseLabelProvider)new JarLabelProvider());
        this.jarViewer.setSorter((ViewerSorter)new JarSorter());
        this.jarTree.addSelectionListener(this.selListener);
        Label classLabel = new Label(composite, 131072);
        classLabel.setText(org.eclipse.jwt.meta.PluginProperties.model_Application_javaClass_name);
        this.classField = new Text(composite, 2048);
        GridData data3 = new GridData();
        data3.horizontalAlignment = 4;
        data3.grabExcessHorizontalSpace = true;
        data3.horizontalSpan = 2;
        this.classField.setLayoutData((Object)data3);
        this.classField.setFocus();
        this.classField.addModifyListener(this.validator);
        Label methodLabel = new Label(composite, 131072);
        methodLabel.setText(String.valueOf(org.eclipse.jwt.meta.PluginProperties.model_Application_method_name) + ":");
        this.methodField = new Text(composite, 2048);
        GridData data4 = new GridData();
        data4.horizontalAlignment = 4;
        data4.grabExcessHorizontalSpace = true;
        data4.horizontalSpan = 2;
        this.methodField.setLayoutData((Object)data4);
        Label isWebserviceLabel = new Label(composite, 131072);
        isWebserviceLabel.setText(PluginProperties.wizards_IsWebServiceApplication_name);
        this.webserviceCheckbox = new Button(composite, 32);
        GridData data5 = new GridData();
        data5.horizontalAlignment = 4;
        data5.grabExcessHorizontalSpace = true;
        data5.horizontalSpan = 2;
        this.webserviceCheckbox.setLayoutData((Object)data5);
        this.webserviceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = SelectJarWizardPage.this.webserviceCheckbox.getSelection();
                if (selected) {
                    SelectJarWizardPage.this.isWebservice = true;
                    SelectJarWizardPage.this.webserviceInterface.setEnabled(true);
                    SelectJarWizardPage.this.webserviceOperation.setEnabled(true);
                } else {
                    SelectJarWizardPage.this.isWebservice = false;
                    SelectJarWizardPage.this.webserviceInterface.setEnabled(false);
                    SelectJarWizardPage.this.webserviceOperation.setEnabled(false);
                }
            }
        });
        Label interfaceLabel = new Label(composite, 131072);
        interfaceLabel.setText(org.eclipse.jwt.meta.PluginProperties.model_WebServiceApplication_interface_name);
        this.webserviceInterface = new Text(composite, 2048);
        GridData data6 = new GridData();
        data6.horizontalAlignment = 4;
        data6.grabExcessHorizontalSpace = true;
        data6.horizontalSpan = 2;
        this.webserviceInterface.setLayoutData((Object)data6);
        this.webserviceInterface.setFocus();
        this.webserviceInterface.addModifyListener(this.validator);
        this.webserviceInterface.setEnabled(false);
        Label operationLabel = new Label(composite, 131072);
        operationLabel.setText(org.eclipse.jwt.meta.PluginProperties.model_WebServiceApplication_operation_name);
        this.webserviceOperation = new Text(composite, 2048);
        GridData data7 = new GridData();
        data7.horizontalAlignment = 4;
        data7.grabExcessHorizontalSpace = true;
        data7.horizontalSpan = 2;
        this.webserviceOperation.setLayoutData((Object)data7);
        this.webserviceOperation.setFocus();
        this.webserviceOperation.setEnabled(false);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    private void setTreeViewerInput() {
        JarFile jarFile = null;
        File file = new File(this.filePath);
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {}
        if (jarFile != null) {
            int size = jarFile.size();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            Hashtable<String, JarNode> nodes = new Hashtable<String, JarNode>();
            JarNode root = new JarNode(jarFile.getName());
            int i = 0;
            while (i < size) {
                JarEntry jarEntry = jarEntries.nextElement();
                String entryName = jarEntry.getName();
                int cutIndex = entryName.lastIndexOf(47);
                String dir = null;
                if (cutIndex != -1) {
                    dir = entryName.substring(0, cutIndex);
                    entryName = entryName.substring(cutIndex + 1);
                }
                JarNode parent = null;
                JarNode lastParent = root;
                if (!entryName.equals("")) {
                    if (dir == null) {
                        parent = root;
                    } else {
                        StringTokenizer tokenizer = new StringTokenizer(dir, "/");
                        String dirpath = "";
                        while (tokenizer.hasMoreTokens()) {
                            String dirName = tokenizer.nextToken();
                            parent = (JarNode)((Object)nodes.get(dirpath = String.valueOf(dirpath) + dirName));
                            if (parent == null) {
                                parent = new JarNode(dirName);
                                lastParent.addChild(parent);
                                nodes.put(dirpath, parent);
                            }
                            lastParent = parent;
                            dirpath = String.valueOf(dirpath) + "/";
                        }
                    }
                    JarNode node = new JarNode(entryName);
                    node.setJarEntry(jarEntry);
                    lastParent.addChild(node);
                }
                ++i;
            }
            this.buildTree(root);
            this.jarViewer.setInput((Object)this.contentProvider.root);
            this.jarViewer.add((Object)this.contentProvider.root, (Object)root);
            this.jarViewer.remove((Object)this.contentProvider.helper);
        }
        try {
            jarFile.close();
        }
        catch (IOException iOException) {}
    }

    private void buildTree(JarNode node) {
        List<TreeNode> childrenList = node.getChildrenList();
        if (!childrenList.isEmpty()) {
            TreeNode[] tn = new TreeNode[childrenList.size()];
            int i = 0;
            while (i < childrenList.size()) {
                tn[i] = childrenList.get(i);
                ++i;
            }
            node.setChildren(tn);
            i = 0;
            while (i < node.getChildren().length) {
                this.buildTree((JarNode)node.getChildren()[i]);
                ++i;
            }
        }
    }

    public String getJar() {
        return this.jarField.getText();
    }

    public String getSelClass() {
        return this.classField.getText();
    }

    public String getMethod() {
        return this.methodField.getText();
    }

    public String getInterface() {
        return this.webserviceInterface.getText();
    }

    public String getOperation() {
        return this.webserviceOperation.getText();
    }

    public boolean getIsWebservice() {
        return this.isWebservice;
    }

    protected boolean validatePage() {
        return this.isWebservice ? this.webserviceInterface.getText() != "" : this.classField.getText() != "";
    }

    class JarContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        public TreeNode root = new TreeNode((Object)"root");
        public TreeNode helper = new TreeNode((Object)PluginProperties.choose_jar_title);

        public JarContentProvider() {
            this.root.setChildren(new TreeNode[]{this.helper});
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return ((TreeNode)child).getParent();
        }

        public Object[] getChildren(Object parent) {
            return ((TreeNode)parent).getChildren();
        }

        public boolean hasChildren(Object parent) {
            return ((TreeNode)parent).hasChildren();
        }
    }

    class JarLabelProvider
    extends LabelProvider {
        JarLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof TreeNode) {
                Object value = ((TreeNode)obj).getValue();
                if (value instanceof JarEntry) {
                    return ((JarEntry)value).getName();
                }
                if (value instanceof File) {
                    return ((File)value).getName();
                }
                if (value instanceof String) {
                    return (String)value;
                }
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            JarNode node;
            String imageKey = "IMG_OBJ_FILE";
            if (obj instanceof JarNode && (node = (JarNode)((Object)obj)).getJarEntry() == null) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JarNode
    extends TreeNode {
        private JarEntry jarEntry;
        private ArrayList<TreeNode> childrenList;

        public JarNode(Object value) {
            super(value);
            this.childrenList = new ArrayList();
        }

        public JarEntry getJarEntry() {
            return this.jarEntry;
        }

        public void setJarEntry(JarEntry jarEntry) {
            this.jarEntry = jarEntry;
        }

        public List<TreeNode> getChildrenList() {
            return this.childrenList;
        }

        public void addChild(TreeNode child) {
            this.childrenList.add(child);
        }
    }

    class JarSorter
    extends ViewerSorter {
        JarSorter() {
        }

        public int category(Object element) {
            if (element instanceof JarNode) {
                if (((JarNode)((Object)element)).getJarEntry() == null) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
    }
}

