/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.layout.VBox;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuItemComponent;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.driver.RobotJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.adapter.AbstractMenuAdapter;
import org.eclipse.jubula.rc.javafx.tester.adapter.MenuAdapter;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class MenuItemAdapter<M extends MenuItem>
extends AbstractMenuAdapter<M>
implements IMenuItemComponent {
    public MenuItemAdapter(M objectToAdapt) {
        super(objectToAdapt);
    }

    public boolean isSelected() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isSelected", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                MenuItem item = (MenuItem)MenuItemAdapter.this.getRealComponent();
                if (item instanceof Toggle) {
                    return ((Toggle)item).isSelected();
                }
                if (item instanceof CheckMenuItem) {
                    return ((CheckMenuItem)item).isSelected();
                }
                return false;
            }
        });
    }

    public String getText() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((MenuItem)MenuItemAdapter.this.getRealComponent()).getText();
            }
        });
    }

    public boolean isEnabled() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isEnabled", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !((MenuItem)MenuItemAdapter.this.getRealComponent()).isDisable();
            }
        });
    }

    public boolean isExisting() {
        return this.getRealComponent() != null;
    }

    public boolean isShowing() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isShowing", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((MenuItem)MenuItemAdapter.this.getRealComponent()).isVisible();
            }
        });
    }

    public boolean hasSubMenu() {
        final MenuItem item = (MenuItem)this.getRealComponent();
        return EventThreadQueuerJavaFXImpl.invokeAndWait("hasSubMenu", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (item instanceof Menu) {
                    if (((Menu)item).getItems().size() > 0) {
                        return true;
                    }
                    return false;
                }
                return false;
            }
        });
    }

    public boolean isSeparator() {
        final MenuItem item = (MenuItem)this.getRealComponent();
        return EventThreadQueuerJavaFXImpl.invokeAndWait("hasSubMenu", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return item instanceof SeparatorMenuItem;
            }
        });
    }

    public void selectMenuItem() {
        this.clickMenuItem();
    }

    public IMenuComponent openSubMenu() {
        MenuItem item = (MenuItem)this.getRealComponent();
        if (!(item instanceof Menu)) {
            throw new StepExecutionException("unexpected item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.clickMenuItem();
        if (!this.waitforSubmenuToOpen((Menu)this.getRealComponent())) {
            throw new StepExecutionException("submenu could not be opened", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
        }
        return new MenuAdapter((Menu)this.getRealComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitforSubmenuToOpen(final Menu menu) {
        boolean result;
        block8: {
            EventHandler<Event> shownHandler;
            block7: {
                final EventLock eventLock = new EventLock();
                shownHandler = new EventHandler<Event>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(Event event) {
                        EventLock eventLock2 = eventLock;
                        synchronized (eventLock2) {
                            eventLock.notifyAll();
                        }
                    }
                };
                EventThreadQueuerJavaFXImpl.invokeAndWait("addShownListener", new Callable<Void>((EventHandler)shownHandler){
                    private final /* synthetic */ EventHandler val$shownHandler;
                    {
                        this.val$shownHandler = eventHandler;
                    }

                    @Override
                    public Void call() throws Exception {
                        menu.addEventHandler(Menu.ON_SHOWN, this.val$shownHandler);
                        return null;
                    }
                });
                result = false;
                try {
                    try {
                        if (menu.isShowing()) break block7;
                        EventLock eventLock2 = eventLock;
                        synchronized (eventLock2) {
                            eventLock.wait(10000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        result = EventThreadQueuerJavaFXImpl.invokeAndWait("openSubMenu", new Callable<Boolean>(menu, (EventHandler)shownHandler){
                            private final /* synthetic */ Menu val$menu;
                            private final /* synthetic */ EventHandler val$shownHandler;
                            {
                                this.val$menu = menu;
                                this.val$shownHandler = eventHandler;
                            }

                            @Override
                            public Boolean call() throws Exception {
                                this.val$menu.removeEventHandler(Menu.ON_SHOWN, this.val$shownHandler);
                                return this.val$menu.isShowing();
                            }
                        });
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    result = EventThreadQueuerJavaFXImpl.invokeAndWait("openSubMenu", new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            result = EventThreadQueuerJavaFXImpl.invokeAndWait("openSubMenu", new /* invalid duplicate definition of identical inner class */);
        }
        return result;
    }

    protected void clickMenuItem() {
        RobotJavaFXImpl robot = this.getRobot();
        final MenuItem item = (MenuItem)this.getRealComponent();
        Node[] nodes = EventThreadQueuerJavaFXImpl.invokeAndWait("clickMenuItem", new Callable<Node[]>(){

            @Override
            public Node[] call() throws Exception {
                if (item.isDisable()) {
                    throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
                }
                Parent p = (Parent)item.getParentPopup().getSkin().getNode();
                ObservableList ctxtMCont = p.getChildrenUnmodifiable();
                VBox mBox = null;
                for (Node node : ctxtMCont) {
                    if (!(node instanceof VBox)) continue;
                    mBox = (VBox)node;
                    break;
                }
                if (mBox == null) {
                    throw new StepExecutionException("No Menu was found", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
                }
                int itemIndex = item.getParentPopup().getItems().indexOf((Object)item);
                Node itemNode = (Node)mBox.getChildrenUnmodifiable().get(itemIndex);
                Node itemOwner = item.getParentPopup().getOwnerNode();
                return new Node[]{itemNode, itemOwner};
            }
        });
        if (nodes[1] != null && nodes[1] instanceof MenuButton) {
            robot.click(nodes[0], null, ClickOptions.create().setFirstHorizontal(false));
        } else {
            robot.click(nodes[0], null);
        }
    }
}

