/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.utils;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class DialogUtils {
    public static final float KEEP_ORIG_SIZE = -1.0f;
    private static final int MODAL = 229376;

    private DialogUtils() {
    }

    public static void setWidgetNameForModalDialog(Dialog dialog) {
        Shell parentShell = dialog.getShell();
        if (parentShell != null && (parentShell.getStyle() & 0x38000) > 0) {
            DialogUtils.setWidgetName((Widget)parentShell, DialogUtils.getShortClassName(dialog.getClass()));
        }
    }

    public static void setWidgetName(Widget widget, String name) {
        if (widget != null && !widget.isDisposed()) {
            widget.setData("TEST_COMP_NAME", (Object)name);
        }
    }

    private static String getShortClassName(Class<?> classObj) {
        String longClassName = String.valueOf(classObj);
        int indexOfLastDot = longClassName.lastIndexOf(46);
        String shortClassName = indexOfLastDot >= 0 ? longClassName.substring(indexOfLastDot + 1) : longClassName;
        return shortClassName;
    }

    public static void adjustShellSizeRelativeToClientSize(Shell shell, float relWidth, float relHeight, SizeType sizeType) {
        DialogUtils.adjustShellSizeRelativeToRectangleSize(shell, relWidth, relHeight, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds(), sizeType);
    }

    public static void adjustShellSizeRelativeToDisplaySize(Shell shell, float relWidth, float relHeight) {
        Display display = Display.getCurrent();
        Rectangle r = display.getClientArea();
        DialogUtils.adjustShellSizeRelativeToRectangleSize(shell, relWidth, relHeight, r, SizeType.SIZE);
    }

    private static void adjustShellSizeRelativeToRectangleSize(Shell shell, float relWidth, float relHeight, Rectangle relativeTo, SizeType sizeType) {
        int dWidth = relativeTo.width;
        int dHeight = relativeTo.height;
        int newShellWidth = 0;
        int newShellHeight = 0;
        newShellWidth = relWidth == -1.0f ? shell.getBounds().width : Math.round(relWidth * (float)dWidth);
        newShellHeight = relHeight == -1.0f ? shell.getBounds().height : Math.round(relHeight * (float)dHeight);
        switch (sizeType) {
            case SIZE: {
                shell.setSize(newShellWidth, newShellHeight);
                break;
            }
            case BOUNDS: {
                break;
            }
        }
        int x = (dWidth - shell.getSize().x) / 2 + relativeTo.x;
        int y = (dHeight - shell.getSize().y) / 2 + relativeTo.y;
        switch (sizeType) {
            case SIZE: {
                shell.setLocation(x, y);
                break;
            }
            case BOUNDS: {
                shell.setBounds(x, y, newShellWidth, newShellHeight);
                break;
            }
        }
    }

    public static Link createLinkToSecureStoragePreferencePage(Composite parent, String linkText) {
        Link l = new Link(parent, 0);
        l.setText(linkText);
        l.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)Plugin.getDefault().getWorkbench().getDisplay().getActiveShell(), (String)"org.eclipse.equinox.security.ui.storage", (String[])new String[]{"org.eclipse.equinox.security.ui.storage"}, null, (int)1).open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return l;
    }

    public static enum SizeType {
        SIZE,
        BOUNDS;

    }
}

